# -*- Perl -*-
# Tests for CNAME records

use Test::More;
use Data::Dumper;

use lib 't';

use DNSTest;
my $dtest = DNSTest::new;

my $code,$msg;
my $rectype = 5;
my $newname;
my $newval;

## Domain tests

subtest 'CNAME add - new name' => sub {
  $newname = 'newname.example.com';
  $newval = 'fredshosting.example.net';
  ($code, $msg) = $dnsdb->addRec('n', 'n', 1, \$newname, \$rectype, \$newval, 900);
  ok( $code eq 'OK', "addRec() claimed succeess" );
  if ($code eq 'OK') {
    # crosscheck in the DB
    ($rcount) = $dbh->selectrow_array("SELECT count(*) FROM records WHERE domain_id = 1 AND host = '$newname'");
    ok( $rcount == 1, " ... [$rcount] yep, hostname only occurs once" );
  } else {
    print "not ok: $msg";
  }
};

subtest 'CNAME add - existing/colliding CNAME' => sub {
  $newname = 'www.example.com';
  ($code, $msg) = $dnsdb->addRec('n', 'n', 1, \$newname, \$rectype, \$newval, 900);
  ok( $code eq 'FAIL', "addRec() claimed failure adding duplicate CNAME" );
  if ($code eq 'FAIL') {
    ($rcount) = $dbh->selectrow_array("SELECT count(*) FROM records WHERE domain_id = 1 AND host = '$newname' AND type = 5");
    ok( $rcount == 1, " ... [$rcount] CNAME already exists" );
    like( $msg, qr/already a CNAME present/, " ... returned matching error" );
  }
};

done_testing();
