--
-- PostgreSQL database dump
--

-- Dumped from database version 9.6.24
-- Dumped by pg_dump version 9.6.24

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: inetlazy(text); Type: FUNCTION; Schema: public; Owner: dnstest
--

CREATE FUNCTION public.inetlazy(rdata text) RETURNS inet
    LANGUAGE plpgsql
    AS $$
BEGIN
	RETURN CAST(rdata AS inet);
EXCEPTION
	WHEN OTHERS THEN
		RETURN CAST('0.0.0.0/0' AS inet);
END;
$$;


ALTER FUNCTION public.inetlazy(rdata text) OWNER TO dnstest;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: default_records; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.default_records (
    record_id integer NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    host text DEFAULT ''::text NOT NULL,
    type integer DEFAULT 1 NOT NULL,
    val text DEFAULT ''::text NOT NULL,
    distance integer DEFAULT 0 NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    port integer DEFAULT 0 NOT NULL,
    ttl integer DEFAULT 86400 NOT NULL,
    description text
);


ALTER TABLE public.default_records OWNER TO dnstest;

--
-- Name: default_records_record_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.default_records_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_records_record_id_seq OWNER TO dnstest;

--
-- Name: default_records_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.default_records_record_id_seq OWNED BY public.default_records.record_id;


--
-- Name: default_rev_records; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.default_rev_records (
    record_id integer NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    host text DEFAULT ''::text NOT NULL,
    type integer DEFAULT 1 NOT NULL,
    val text DEFAULT ''::text NOT NULL,
    ttl integer DEFAULT 86400 NOT NULL,
    description text
);


ALTER TABLE public.default_rev_records OWNER TO dnstest;

--
-- Name: default_rev_records_record_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.default_rev_records_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_rev_records_record_id_seq OWNER TO dnstest;

--
-- Name: default_rev_records_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.default_rev_records_record_id_seq OWNED BY public.default_rev_records.record_id;


--
-- Name: domains; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.domains (
    domain_id integer NOT NULL,
    domain character varying(80) NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    description character varying(255) DEFAULT ''::character varying NOT NULL,
    status integer DEFAULT 1 NOT NULL,
    zserial integer,
    sertype character(1) DEFAULT 'D'::bpchar,
    changed boolean DEFAULT true NOT NULL,
    default_location character varying(4) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.domains OWNER TO dnstest;

--
-- Name: domains_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.domains_domain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.domains_domain_id_seq OWNER TO dnstest;

--
-- Name: domains_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.domains_domain_id_seq OWNED BY public.domains.domain_id;


--
-- Name: groups; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.groups (
    group_id integer NOT NULL,
    parent_group_id integer DEFAULT 1 NOT NULL,
    group_name character varying(255) DEFAULT ''::character varying NOT NULL,
    permission_id integer DEFAULT 1 NOT NULL,
    inherit_perm boolean DEFAULT true NOT NULL
);


ALTER TABLE public.groups OWNER TO dnstest;

--
-- Name: groups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.groups_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.groups_group_id_seq OWNER TO dnstest;

--
-- Name: groups_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.groups_group_id_seq OWNED BY public.groups.group_id;


--
-- Name: locations; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.locations (
    location character varying(4) NOT NULL,
    loc_id integer NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    iplist text DEFAULT ''::text NOT NULL,
    description character varying(40) DEFAULT ''::character varying NOT NULL,
    comments text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.locations OWNER TO dnstest;

--
-- Name: locations_loc_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.locations_loc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.locations_loc_id_seq OWNER TO dnstest;

--
-- Name: locations_loc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.locations_loc_id_seq OWNED BY public.locations.loc_id;


--
-- Name: log; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.log (
    log_id integer NOT NULL,
    domain_id integer,
    user_id integer,
    group_id integer,
    email character varying(60),
    name character varying(60),
    entry text,
    stamp timestamp with time zone DEFAULT now(),
    rdns_id integer,
    logparent integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.log OWNER TO dnstest;

--
-- Name: log_log_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.log_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.log_log_id_seq OWNER TO dnstest;

--
-- Name: log_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.log_log_id_seq OWNED BY public.log.log_id;


--
-- Name: misc; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.misc (
    misc_id integer NOT NULL,
    key text DEFAULT ''::text NOT NULL,
    value text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.misc OWNER TO dnstest;

--
-- Name: misc_misc_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.misc_misc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.misc_misc_id_seq OWNER TO dnstest;

--
-- Name: misc_misc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.misc_misc_id_seq OWNED BY public.misc.misc_id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.permissions (
    permission_id integer NOT NULL,
    admin boolean DEFAULT false NOT NULL,
    self_edit boolean DEFAULT false NOT NULL,
    group_create boolean DEFAULT false NOT NULL,
    group_edit boolean DEFAULT false NOT NULL,
    group_delete boolean DEFAULT false NOT NULL,
    user_create boolean DEFAULT false NOT NULL,
    user_edit boolean DEFAULT false NOT NULL,
    user_delete boolean DEFAULT false NOT NULL,
    domain_create boolean DEFAULT false NOT NULL,
    domain_edit boolean DEFAULT false NOT NULL,
    domain_delete boolean DEFAULT false NOT NULL,
    record_create boolean DEFAULT false NOT NULL,
    record_edit boolean DEFAULT false NOT NULL,
    record_delete boolean DEFAULT false NOT NULL,
    user_id integer,
    group_id integer,
    record_locchg boolean DEFAULT false NOT NULL,
    location_create boolean DEFAULT false NOT NULL,
    location_edit boolean DEFAULT false NOT NULL,
    location_delete boolean DEFAULT false NOT NULL,
    location_view boolean DEFAULT false NOT NULL
);


ALTER TABLE public.permissions OWNER TO dnstest;

--
-- Name: permissions_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.permissions_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_permission_id_seq OWNER TO dnstest;

--
-- Name: permissions_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.permissions_permission_id_seq OWNED BY public.permissions.permission_id;


--
-- Name: records; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.records (
    domain_id integer DEFAULT 0 NOT NULL,
    record_id integer NOT NULL,
    host text DEFAULT ''::text NOT NULL,
    type integer DEFAULT 1 NOT NULL,
    val text DEFAULT ''::text NOT NULL,
    distance integer DEFAULT 0 NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    port integer DEFAULT 0 NOT NULL,
    ttl integer DEFAULT 7200 NOT NULL,
    description text,
    rdns_id integer DEFAULT 0 NOT NULL,
    location character varying(4) DEFAULT ''::character varying NOT NULL,
    stamp timestamp with time zone DEFAULT '1969-12-31 19:00:00-05'::timestamp with time zone NOT NULL,
    expires boolean DEFAULT false NOT NULL,
    stampactive boolean DEFAULT false NOT NULL,
    auxdata text
);


ALTER TABLE public.records OWNER TO dnstest;

--
-- Name: records_record_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.records_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.records_record_id_seq OWNER TO dnstest;

--
-- Name: records_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.records_record_id_seq OWNED BY public.records.record_id;


--
-- Name: rectypes; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.rectypes (
    val integer NOT NULL,
    name character varying(20) NOT NULL,
    stdflag integer DEFAULT 1 NOT NULL,
    listorder integer DEFAULT 255 NOT NULL,
    alphaorder integer DEFAULT 32768 NOT NULL
);


ALTER TABLE public.rectypes OWNER TO dnstest;

--
-- Name: refresh_zones; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.refresh_zones (
    zone text NOT NULL,
    view text DEFAULT ''::text NOT NULL,
    export_stamp integer DEFAULT date_part('epoch'::text, now()),
    reftype text DEFAULT 'update'::text
);


ALTER TABLE public.refresh_zones OWNER TO dnstest;

--
-- Name: revzones; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.revzones (
    rdns_id integer NOT NULL,
    revnet cidr NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    description character varying(255) DEFAULT ''::character varying NOT NULL,
    status integer DEFAULT 1 NOT NULL,
    zserial integer,
    sertype character(1) DEFAULT 'D'::bpchar,
    changed boolean DEFAULT true NOT NULL,
    default_location character varying(4) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.revzones OWNER TO dnstest;

--
-- Name: revzones_rdns_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.revzones_rdns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.revzones_rdns_id_seq OWNER TO dnstest;

--
-- Name: revzones_rdns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.revzones_rdns_id_seq OWNED BY public.revzones.rdns_id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: dnstest
--

CREATE TABLE public.users (
    user_id integer NOT NULL,
    group_id integer DEFAULT 1 NOT NULL,
    username character varying(60) NOT NULL,
    password character varying(34) NOT NULL,
    firstname character varying(60),
    lastname character varying(60),
    phone character varying(15),
    type character(1) DEFAULT 'S'::bpchar NOT NULL,
    status integer DEFAULT 1 NOT NULL,
    permission_id integer DEFAULT 1 NOT NULL,
    inherit_perm boolean DEFAULT true NOT NULL
);


ALTER TABLE public.users OWNER TO dnstest;

--
-- Name: users_user_id_seq; Type: SEQUENCE; Schema: public; Owner: dnstest
--

CREATE SEQUENCE public.users_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_user_id_seq OWNER TO dnstest;

--
-- Name: users_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dnstest
--

ALTER SEQUENCE public.users_user_id_seq OWNED BY public.users.user_id;


--
-- Name: default_records record_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.default_records ALTER COLUMN record_id SET DEFAULT nextval('public.default_records_record_id_seq'::regclass);


--
-- Name: default_rev_records record_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.default_rev_records ALTER COLUMN record_id SET DEFAULT nextval('public.default_rev_records_record_id_seq'::regclass);


--
-- Name: domains domain_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.domains ALTER COLUMN domain_id SET DEFAULT nextval('public.domains_domain_id_seq'::regclass);


--
-- Name: groups group_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.groups ALTER COLUMN group_id SET DEFAULT nextval('public.groups_group_id_seq'::regclass);


--
-- Name: locations loc_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.locations ALTER COLUMN loc_id SET DEFAULT nextval('public.locations_loc_id_seq'::regclass);


--
-- Name: log log_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.log ALTER COLUMN log_id SET DEFAULT nextval('public.log_log_id_seq'::regclass);


--
-- Name: misc misc_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.misc ALTER COLUMN misc_id SET DEFAULT nextval('public.misc_misc_id_seq'::regclass);


--
-- Name: permissions permission_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.permissions ALTER COLUMN permission_id SET DEFAULT nextval('public.permissions_permission_id_seq'::regclass);


--
-- Name: records record_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.records ALTER COLUMN record_id SET DEFAULT nextval('public.records_record_id_seq'::regclass);


--
-- Name: revzones rdns_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.revzones ALTER COLUMN rdns_id SET DEFAULT nextval('public.revzones_rdns_id_seq'::regclass);


--
-- Name: users user_id; Type: DEFAULT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.users ALTER COLUMN user_id SET DEFAULT nextval('public.users_user_id_seq'::regclass);


--
-- Data for Name: default_records; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.default_records (record_id, group_id, host, type, val, distance, weight, port, ttl, description) FROM stdin;
1	1	ns1.example.com:hostmaster.DOMAIN	6	10800:3600:604800:5400	0	0	0	86400	\N
2	1	DOMAIN	2	ns2.example.com	0	0	0	7200	\N
3	1	DOMAIN	2	ns1.example.com	0	0	0	7200	\N
4	1	DOMAIN	1	10.0.0.4	0	0	0	7200	\N
5	1	DOMAIN	15	mx1.example.com	10	0	0	7200	\N
6	1	www.DOMAIN	5	DOMAIN	0	0	0	10800	\N
7	1	DOMAIN	16	"v=spf1 a mx -all"	0	0	0	10800	\N
\.


--
-- Name: default_records_record_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.default_records_record_id_seq', 8, true);


--
-- Data for Name: default_rev_records; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.default_rev_records (record_id, group_id, host, type, val, ttl, description) FROM stdin;
1	1	hostmaster.ADMINDOMAIN:ns1.ADMINDOMAIN	6	3600:900:1048576:2560	3600	
2	1	unused-%r.ADMINDOMAIN	65283	ZONE	3600	
3	1	ns2.example.com	2	ZONE	7200	\N
4	1	ns1.example.com	2	ZONE	7200	\N
\.


--
-- Name: default_rev_records_record_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.default_rev_records_record_id_seq', 4, true);


--
-- Data for Name: domains; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.domains (domain_id, domain, group_id, description, status, zserial, sertype, changed, default_location) FROM stdin;
1	example.com	1		1	2025123002	D	f	
2	example.org	1		1	2025121800	D	f	ac
3	example.net	1		1	2025121800	D	f	ab
4	expiry1.test	1		1	2026011400	D	t	
5	expiry2.test	1		1	2026011901	D	t	
6	expiry3.test	1		1	2026020311	D	t	
\.


--
-- Name: domains_domain_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.domains_domain_id_seq', 6, true);


--
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.groups (group_id, parent_group_id, group_name, permission_id, inherit_perm) FROM stdin;
1	1	default	1	t
\.


--
-- Name: groups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.groups_group_id_seq', 1, true);


--
-- Data for Name: locations; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.locations (location, loc_id, group_id, iplist, description, comments) FROM stdin;
aa	1	1		Default	
ab	2	1	192.168.2.0/24	LAN 1	
ac	3	1	172.16.16.0/24	Fred	
\.


--
-- Name: locations_loc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.locations_loc_id_seq', 3, true);


--
-- Data for Name: log; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.log (log_id, domain_id, user_id, group_id, email, name, entry, stamp, rdns_id, logparent) FROM stdin;
1	1	1	1	admin	Initial User	Added active domain example.com	2025-12-17 12:24:46.11906-05	0	0
2	1	1	1	admin	Initial User	[new example.com] Added SOA record [contact ns1.example.com] [master hostmaster.example.com] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2025-12-17 12:24:46.11906-05	0	1
3	1	1	1	admin	Initial User	[new example.com] Added record 'example.com NS ns2.example.com', TTL 7200	2025-12-17 12:24:46.11906-05	0	1
4	1	1	1	admin	Initial User	[new example.com] Added record 'example.com NS ns1.example.com', TTL 7200	2025-12-17 12:24:46.11906-05	0	1
5	1	1	1	admin	Initial User	[new example.com] Added record 'example.com A 10.0.0.4', TTL 7200	2025-12-17 12:24:46.11906-05	0	1
6	1	1	1	admin	Initial User	[new example.com] Added record 'example.com MX [distance 10] mx1.example.com', TTL 7200	2025-12-17 12:24:46.11906-05	0	1
7	1	1	1	admin	Initial User	[new example.com] Added record 'www.example.com CNAME example.com', TTL 10800	2025-12-17 12:24:46.11906-05	0	1
8	1	1	1	admin	Initial User	[new example.com] Added record 'example.com TXT "v=spf1 a mx -all"', TTL 10800	2025-12-17 12:24:46.11906-05	0	1
9	0	1	\N	admin	Initial User	Added location (Default, '')	2025-12-17 12:25:11.191152-05	0	0
10	0	1	\N	admin	Initial User	Added location (LAN 1, '192.168.2.0/24')	2025-12-17 12:25:33.836951-05	0	0
11	0	1	\N	admin	Initial User	Added location (Fred, '172.16.16.0/24')	2025-12-17 12:25:51.949666-05	0	0
12	2	1	1	admin	Initial User	Added active domain example.org	2025-12-17 12:26:19.324182-05	0	0
13	2	1	1	admin	Initial User	[new example.org] Added SOA record [contact ns1.example.com] [master hostmaster.example.org] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2025-12-17 12:26:19.324182-05	0	12
14	2	1	1	admin	Initial User	[new example.org] Added record 'example.org NS ns2.example.com', TTL 7200	2025-12-17 12:26:19.324182-05	0	12
15	2	1	1	admin	Initial User	[new example.org] Added record 'example.org NS ns1.example.com', TTL 7200	2025-12-17 12:26:19.324182-05	0	12
16	2	1	1	admin	Initial User	[new example.org] Added record 'example.org A 10.0.0.4', TTL 7200	2025-12-17 12:26:19.324182-05	0	12
17	2	1	1	admin	Initial User	[new example.org] Added record 'example.org MX [distance 10] mx1.example.com', TTL 7200	2025-12-17 12:26:19.324182-05	0	12
18	2	1	1	admin	Initial User	[new example.org] Added record 'www.example.org CNAME example.org', TTL 10800	2025-12-17 12:26:19.324182-05	0	12
19	2	1	1	admin	Initial User	[new example.org] Added record 'example.org TXT "v=spf1 a mx -all"', TTL 10800	2025-12-17 12:26:19.324182-05	0	12
20	3	1	1	admin	Initial User	Added active domain example.net	2025-12-17 12:26:35.195757-05	0	0
21	3	1	1	admin	Initial User	[new example.net] Added SOA record [contact ns1.example.com] [master hostmaster.example.net] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2025-12-17 12:26:35.195757-05	0	20
22	3	1	1	admin	Initial User	[new example.net] Added record 'example.net NS ns2.example.com', TTL 7200	2025-12-17 12:26:35.195757-05	0	20
23	3	1	1	admin	Initial User	[new example.net] Added record 'example.net NS ns1.example.com', TTL 7200	2025-12-17 12:26:35.195757-05	0	20
24	3	1	1	admin	Initial User	[new example.net] Added record 'example.net A 10.0.0.4', TTL 7200	2025-12-17 12:26:35.195757-05	0	20
25	3	1	1	admin	Initial User	[new example.net] Added record 'example.net MX [distance 10] mx1.example.com', TTL 7200	2025-12-17 12:26:35.195757-05	0	20
26	3	1	1	admin	Initial User	[new example.net] Added record 'www.example.net CNAME example.net', TTL 10800	2025-12-17 12:26:35.195757-05	0	20
27	3	1	1	admin	Initial User	[new example.net] Added record 'example.net TXT "v=spf1 a mx -all"', TTL 10800	2025-12-17 12:26:35.195757-05	0	20
28	4	1	1	admin	Initial User	Added active domain expiry1.test	2025-12-17 12:26:47.718202-05	0	0
29	4	1	1	admin	Initial User	[new expiry1.test] Added SOA record [contact ns1.example.com] [master hostmaster.expiry1.test] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2025-12-17 12:26:47.718202-05	0	28
30	4	1	1	admin	Initial User	[new expiry1.test] Added record 'expiry1.test NS ns2.example.com', TTL 7200	2025-12-17 12:26:47.718202-05	0	28
31	4	1	1	admin	Initial User	[new expiry1.test] Added record 'expiry1.test NS ns1.example.com', TTL 7200	2025-12-17 12:26:47.718202-05	0	28
32	4	1	1	admin	Initial User	[new expiry1.test] Added record 'expiry1.test A 10.0.0.4', TTL 7200	2025-12-17 12:26:47.718202-05	0	28
33	4	1	1	admin	Initial User	[new expiry1.test] Added record 'expiry1.test MX [distance 10] mx1.example.com', TTL 7200	2025-12-17 12:26:47.718202-05	0	28
34	4	1	1	admin	Initial User	[new expiry1.test] Added record 'www.expiry1.test CNAME expiry1.test', TTL 10800	2025-12-17 12:26:47.718202-05	0	28
35	4	1	1	admin	Initial User	[new expiry1.test] Added record 'expiry1.test TXT "v=spf1 a mx -all"', TTL 10800	2025-12-17 12:26:47.718202-05	0	28
36	0	1	1	admin	Initial User	Added active reverse zone 192.168.2.0/24	2025-12-17 12:27:28.623209-05	1	0
37	0	1	1	admin	Initial User	[new 192.168.2.0/24] Added SOA record [contact hostmaster.example.com] [master ns1.example.com] [refresh 3600] [retry 900] [expire 1048576] [minttl 2560], TTL 3600	2025-12-17 12:27:28.623209-05	1	0
38	0	1	1	admin	Initial User	[new 192.168.2.0/24] Added record 'ns2.example.com NS 192.168.2.0/24', TTL 7200	2025-12-17 12:27:28.623209-05	1	0
39	0	1	1	admin	Initial User	[new 192.168.2.0/24] Added record 'ns1.example.com NS 192.168.2.0/24', TTL 7200	2025-12-17 12:27:28.623209-05	1	0
40	1	1	1	admin	Initial User	[new 192.168.2.0/24] Added record 'lan-%ip.example.com A+PTR template 192.168.2.0/24', TTL 2560 from pattern	2025-12-17 12:27:28.623209-05	1	0
41	1	1	1	admin	Initial User	Added record 'mx1.example.com A 192.168.2.42', TTL 900	2025-12-17 16:43:46.2434-05	0	0
42	0	1	1	admin	Initial User	Added record '192.168.2.13 CNAME 13-29.arpa.example.net', TTL 2560	2025-12-18 11:06:54.803316-05	1	0
43	2	1	1	admin	Initial User	Added record '192.168.2.8/29 A+PTR template %r.example.org', TTL 2560	2025-12-18 11:07:33.593748-05	1	0
44	2	1	1	admin	Initial User	Added record '192.168.2.14 A+PTR floop.example.org', TTL 2560	2025-12-18 11:20:12.736034-05	1	0
45	1	1	1	admin	Initial User	Added record 'mail.example.com CNAME mx1.example.com', TTL 5400	2025-12-18 13:29:49.375721-05	0	0
46	1	1	1	admin	Initial User	Added record 'mx1.example.com TXT v=spf1 ip4:192.168.2.42', TTL 5400	2025-12-18 13:43:31.999061-05	0	0
47	1	1	1	admin	Initial User	Added record 'smtp.example.com A 192.168.2.11', TTL 5400	2025-12-18 18:09:00.580415-05	0	0
48	1	1	1	admin	Initial User	Added record 'webthing.example.com CNAME example.com', TTL 5400	2025-12-22 17:18:16.478475-05	0	0
49	1	1	1	admin	Initial User	Added record 'stuff.example.com CNAME example.com', TTL 5400	2025-12-22 17:22:23.125145-05	0	0
50	0	1	1	admin	Initial User	Added record '192.168.2.14 TXT we are text', TTL 2560	2025-12-22 18:17:14.386997-05	1	0
51	0	1	1	admin	Initial User	Added record '192.168.2.15 TXT some other text', TTL 2560	2025-12-22 18:19:51.428323-05	1	0
52	0	1	1	admin	Initial User	Added record '192.168.2.16 CNAME 16.16-29.2.168.192.in-addr.arpa', TTL 2560	2025-12-23 11:29:50.084066-05	1	0
53	0	1	1	admin	Initial User	Added record '192.168.2.17 TXT imma blocker!', TTL 2560	2025-12-23 13:06:20.492137-05	1	0
55	0	1	1	admin	Initial User	Added record '192.168.2.18 CNAME 18-2.arpa.example.com', TTL 2560	2026-01-07 16:37:03.094557-05	1	0
56	4	1	1	admin	Initial User	Added record 'expired1.expiry1.test A 192.168.2.23', TTL 5400, expires at 2025-12-24 18:30	2026-01-07 17:55:46.022401-05	0	0
57	4	1	1	admin	Initial User	Added record 'expired2.expiry1.test TXT imma expire soon', TTL 5400, expires at 2026-01-10 07:00	2026-01-07 17:57:07.015962-05	0	0
58	4	1	1	admin	Initial User	Added record 'active-after1.expiry1.test TXT not active yet', TTL 5400, valid after 2026-01-11 11:30	2026-01-07 18:12:57.491476-05	0	0
59	4	1	1	admin	Initial User	Added record 'active-after2.expiry1.test TXT I'm done waiting', TTL 5400, expires at 2025-12-31 14:00	2026-01-14 18:02:13.876839-05	0	0
60	5	1	1	admin	Initial User	Added active domain expiry2.test	2026-01-15 12:08:59.951774-05	0	0
61	5	1	1	admin	Initial User	[new expiry2.test] Added SOA record [contact ns1.example.com] [master hostmaster.expiry2.test] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2026-01-15 12:08:59.951774-05	0	60
62	5	1	1	admin	Initial User	[new expiry2.test] Added record 'expiry2.test NS ns2.example.com', TTL 7200	2026-01-15 12:08:59.951774-05	0	60
63	5	1	1	admin	Initial User	[new expiry2.test] Added record 'expiry2.test NS ns1.example.com', TTL 7200	2026-01-15 12:08:59.951774-05	0	60
64	5	1	1	admin	Initial User	[new expiry2.test] Added record 'expiry2.test A 10.0.0.4', TTL 7200	2026-01-15 12:08:59.951774-05	0	60
65	5	1	1	admin	Initial User	[new expiry2.test] Added record 'expiry2.test MX [distance 10] mx1.example.com', TTL 7200	2026-01-15 12:08:59.951774-05	0	60
66	5	1	1	admin	Initial User	[new expiry2.test] Added record 'www.expiry2.test CNAME expiry2.test', TTL 10800	2026-01-15 12:08:59.951774-05	0	60
67	5	1	1	admin	Initial User	[new expiry2.test] Added record 'expiry2.test TXT "v=spf1 a mx -all"', TTL 10800	2026-01-15 12:08:59.951774-05	0	60
68	5	1	1	admin	Initial User	Added record 'expires-at1.expiry2.test TXT Hanging around', TTL 5400	2026-01-15 12:57:28.411931-05	0	0
69	5	1	1	admin	Initial User	Added record 'expires-at2.expiry2.test TXT imma expire soon', TTL 5400, expires at 2026-01-15 18:00	2026-01-15 12:58:51.09629-05	0	0
70	5	1	1	admin	Initial User	Added record 'expires-at3.expiry2.test TXT active after pending expiry', TTL 5400, expires at 2026-01-15 18:00	2026-01-15 13:21:31.833257-05	0	0
71	5	1	1	admin	Initial User	Added record 'expires-at4.expiry2.test TXT active before pending expiry', TTL 5400, expires at 2026-01-15 18:00	2026-01-15 17:59:01.61806-05	0	0
72	5	1	1	admin	Initial User	Added record 'expires-at5.expiry2.test TXT expired before now', TTL 5400, expires at 2026-01-15 18:00	2026-01-16 11:50:43.678446-05	0	0
73	5	1	1	admin	Initial User	Added record 'valid-after1.expiry2.test TXT always here', TTL 5400	2026-01-16 13:36:36.066418-05	0	0
74	5	1	1	admin	Initial User	Added record 'valid-after2.expiry2.test TXT valid soon', TTL 5400, expires at 2026-01-15 18:00	2026-01-16 13:38:57.274666-05	0	0
75	5	1	1	admin	Initial User	Added record 'valid-after3.expiry2.test TXT valid days ago', TTL 5400, expires at 2026-01-15 18:00	2026-01-16 13:45:27.179614-05	0	0
76	5	1	1	admin	Initial User	Added record 'valid-after4.expiry2.test TXT valid quite soon', TTL 5400, expires at 2026-01-15 18:00	2026-01-19 11:40:07.438603-05	0	0
77	5	1	1	admin	Initial User	Added record 'valid-after5.expiry2.test TXT expires before pending valid', TTL 5400, expires at 2026-01-15 18:00	2026-01-19 11:40:55.325144-05	0	0
78	6	1	1	admin	Initial User	Added active domain expiry3.test	2026-01-29 18:05:53.678277-05	0	0
79	6	1	1	admin	Initial User	[new expiry3.test] Added SOA record [contact ns1.example.com] [master hostmaster.expiry3.test] [refresh 10800] [retry 3600] [expire 604800] [minttl 5400], TTL 86400	2026-01-29 18:05:53.678277-05	0	78
80	6	1	1	admin	Initial User	[new expiry3.test] Added record 'expiry3.test NS ns2.example.com', TTL 7200	2026-01-29 18:05:53.678277-05	0	78
81	6	1	1	admin	Initial User	[new expiry3.test] Added record 'expiry3.test NS ns1.example.com', TTL 7200	2026-01-29 18:05:53.678277-05	0	78
82	6	1	1	admin	Initial User	[new expiry3.test] Added record 'expiry3.test A 10.0.0.4', TTL 7200	2026-01-29 18:05:53.678277-05	0	78
83	6	1	1	admin	Initial User	[new expiry3.test] Added record 'expiry3.test MX [distance 10] mx1.example.com', TTL 7200	2026-01-29 18:05:53.678277-05	0	78
84	6	1	1	admin	Initial User	[new expiry3.test] Added record 'www.expiry3.test CNAME expiry3.test', TTL 10800	2026-01-29 18:05:53.678277-05	0	78
85	6	1	1	admin	Initial User	[new expiry3.test] Added record 'expiry3.test TXT "v=spf1 a mx -all"', TTL 10800	2026-01-29 18:05:53.678277-05	0	78
86	6	1	1	admin	Initial User	Added record 'nostamp1a.expiry3.test TXT target - expired', TTL 5400, expires at 2026-01-29 14:00	2026-01-30 15:07:08.695134-05	0	0
87	6	1	1	admin	Initial User	Added record 'nostamp2a.expiry3.test TXT target - soon to expire', TTL 5400, expires at 2026-01-31 14:00	2026-01-30 15:07:34.780671-05	0	0
88	6	1	1	admin	Initial User	Added record 'nostamp3a.expiry3.test TXT target - valid soon', TTL 5400, valid after 2026-01-31 14:00	2026-01-30 15:07:53.379107-05	0	0
89	6	1	1	admin	Initial User	Added record 'nostamp4a.expiry3.test TXT target - already valid', TTL 5400, valid after 2026-01-29 14:00	2026-01-30 15:08:15.4399-05	0	0
90	6	1	1	admin	Initial User	Added record 'nostamp1b.expiry3.test TXT to change', TTL 5400	2026-01-30 15:29:48.433198-05	0	0
91	6	1	1	admin	Initial User	Added record 'nostamp2b.expiry3.test TXT to change', TTL 5400	2026-01-30 15:29:53.902318-05	0	0
92	6	1	1	admin	Initial User	Added record 'nostamp3b.expiry3.test TXT to change', TTL 5400	2026-01-30 15:29:57.875273-05	0	0
93	6	1	1	admin	Initial User	Added record 'nostamp4b.expiry3.test TXT to change', TTL 5400	2026-01-30 15:30:01.924263-05	0	0
94	6	1	1	admin	Initial User	Added record 'expires1a.expiry3.test TXT target - no timestamp', TTL 5400	2026-02-03 12:02:32.883354-05	0	0
95	6	1	1	admin	Initial User	Added record 'expires2a.expiry3.test TXT target - expired', TTL 5400, expires at 2026-01-29 14:00	2026-02-03 12:03:09.031474-05	0	0
96	6	1	1	admin	Initial User	Added record 'expires3a.expiry3.test TXT target - expires soon', TTL 5400, expires at 2026-01-31 14:00	2026-02-03 12:04:30.954558-05	0	0
97	6	1	1	admin	Initial User	Added record 'expires4a.expiry3.test TXT target - valid soon', TTL 5400, valid after 2026-01-31 14:00	2026-02-03 12:04:52.864866-05	0	0
98	6	1	1	admin	Initial User	Added record 'expires5a.expiry3.test TXT target - already valid', TTL 5400, valid after 2026-01-29 14:00	2026-02-03 12:05:10.629373-05	0	0
99	6	1	1	admin	Initial User	Added record 'expires6a.expiry3.test TXT target - valid less soon', TTL 5400, valid after 2026-01-15 18:00	2026-02-03 12:05:31.096289-05	0	0
100	6	1	1	admin	Initial User	Added record 'expires1b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:05:33.779645-05	0	0
101	6	1	1	admin	Initial User	Added record 'expires2b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:05:44.12329-05	0	0
102	6	1	1	admin	Initial User	Added record 'expires3b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:05:50.968888-05	0	0
103	6	1	1	admin	Initial User	Added record 'expires4b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:05:56.415551-05	0	0
104	6	1	1	admin	Initial User	Added record 'expires5b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:06:01.591204-05	0	0
105	6	1	1	admin	Initial User	Added record 'expires6b.expiry3.test TXT to change', TTL 5400	2026-02-03 12:06:34.192183-05	0	0
\.


--
-- Name: log_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.log_log_id_seq', 105, true);


--
-- Data for Name: misc; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.misc (misc_id, key, value) FROM stdin;
1	dbversion	1.4.2
\.


--
-- Name: misc_misc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.misc_misc_id_seq', 1, true);


--
-- Data for Name: permissions; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.permissions (permission_id, admin, self_edit, group_create, group_edit, group_delete, user_create, user_edit, user_delete, domain_create, domain_edit, domain_delete, record_create, record_edit, record_delete, user_id, group_id, record_locchg, location_create, location_edit, location_delete, location_view) FROM stdin;
1	f	f	f	f	f	f	f	f	t	t	t	t	t	t	\N	1	f	f	f	f	f
2	t	f	f	f	f	f	f	f	f	f	f	f	f	f	1	\N	f	f	f	f	f
\.


--
-- Name: permissions_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.permissions_permission_id_seq', 2, true);


--
-- Data for Name: records; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.records (domain_id, record_id, host, type, val, distance, weight, port, ttl, description, rdns_id, location, stamp, expires, stampactive, auxdata) FROM stdin;
1	1	ns1.example.com:hostmaster.example.com	6	10800:3600:604800:5400	0	0	0	86400	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	2	example.com	2	ns2.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	3	example.com	2	ns1.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	4	example.com	1	10.0.0.4	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	5	example.com	15	mx1.example.com	10	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	6	www.example.com	5	example.com	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	7	example.com	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
2	8	ns1.example.com:hostmaster.example.org	6	10800:3600:604800:5400	0	0	0	86400	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	9	example.org	2	ns2.example.com	0	0	0	7200	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	10	example.org	2	ns1.example.com	0	0	0	7200	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	11	example.org	1	10.0.0.4	0	0	0	7200	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	12	example.org	15	mx1.example.com	10	0	0	7200	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	13	www.example.org	5	example.org	0	0	0	10800	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
2	14	example.org	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0	ac	1969-12-31 19:00:00-05	f	f	\N
3	15	ns1.example.com:hostmaster.example.net	6	10800:3600:604800:5400	0	0	0	86400	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	16	example.net	2	ns2.example.com	0	0	0	7200	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	17	example.net	2	ns1.example.com	0	0	0	7200	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	18	example.net	1	10.0.0.4	0	0	0	7200	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	19	example.net	15	mx1.example.com	10	0	0	7200	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	20	www.example.net	5	example.net	0	0	0	10800	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
3	21	example.net	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0	ab	1969-12-31 19:00:00-05	f	f	\N
4	22	ns1.example.com:hostmaster.expiry1.test	6	10800:3600:604800:5400	0	0	0	86400	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	23	expiry1.test	2	ns2.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	24	expiry1.test	2	ns1.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	25	expiry1.test	1	10.0.0.4	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	26	expiry1.test	15	mx1.example.com	10	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	27	www.expiry1.test	5	expiry1.test	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
4	28	expiry1.test	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
0	29	hostmaster.example.com:ns1.example.com	6	3600:900:1048576:2560	0	0	0	3600	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	30	ns2.example.com	2	192.168.2.0/24	0	0	0	7200	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	31	ns1.example.com	2	192.168.2.0/24	0	0	0	7200	\N	1		1969-12-31 19:00:00-05	f	f	\N
1	32	lan-%ip.example.com	65283	192.168.2.0/24	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
1	33	mx1.example.com	1	192.168.2.42	0	0	0	900	\N	0		1969-12-31 19:00:00-05	f	f	\N
0	34	13-29.arpa.example.net	5	192.168.2.13	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
2	35	%r.example.org	65283	192.168.2.8/29	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
2	36	floop.example.org	65280	192.168.2.14	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
1	37	mail.example.com	5	mx1.example.com	0	0	0	900	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	38	mx1.example.com	16	v=spf1 ip4:192.168.2.42	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	39	smtp.example.com	1	192.168.2.11	0	0	0	900	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	40	webthing.example.com	5	example.com	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
1	41	stuff.example.com	5	example.com	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
0	42	we are text	16	192.168.2.14	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	43	some other text	16	192.168.2.15	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	44	16.16-29.2.168.192.in-addr.arpa	5	192.168.2.16	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	45	imma blocker!	16	192.168.2.17	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
0	46	18-2.arpa.example.com	5	192.168.2.18	0	0	0	2560	\N	1		1969-12-31 19:00:00-05	f	f	\N
4	47	expired1.expiry1.test	1	192.168.2.23	0	0	0	5400	\N	0		2025-12-24 18:30:00-05	t	t	\N
4	48	expired2.expiry1.test	16	imma expire soon	0	0	0	5400	\N	0		2026-01-10 07:00:00-05	t	t	\N
4	49	active-after1.expiry1.test	16	not active yet	0	0	0	5400	\N	0		2026-01-11 11:30:00-05	f	t	\N
4	50	active-after2.expiry1.test	16	I'm done waiting	0	0	0	5400	\N	0		2025-12-31 14:00:00-05	f	t	\N
5	51	ns1.example.com:hostmaster.expiry2.test	6	10800:3600:604800:5400	0	0	0	86400	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	52	expiry2.test	2	ns2.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	53	expiry2.test	2	ns1.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	54	expiry2.test	1	10.0.0.4	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	55	expiry2.test	15	mx1.example.com	10	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	56	www.expiry2.test	5	expiry2.test	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	57	expiry2.test	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	58	expires-at1.expiry2.test	16	Hanging around	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	59	expires-at2.expiry2.test	16	imma expire soon	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	t	t	\N
5	60	expires-at3.expiry2.test	16	active after pending expiry	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	f	t	\N
5	61	expires-at4.expiry2.test	16	active before pending expiry	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	f	t	\N
5	62	expires-at5.expiry2.test	16	expired before now	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	t	t	\N
5	63	valid-after1.expiry2.test	16	always here	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
5	64	valid-after2.expiry2.test	16	expires soon	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	t	t	\N
5	65	valid-after3.expiry2.test	16	valid days ago	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	f	t	\N
5	66	valid-after4.expiry2.test	16	valid quite soon	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	f	t	\N
5	67	valid-after5.expiry2.test	16	expires before pending valid	0	0	0	5400	\N	0		2026-01-15 18:00:00-05	t	t	\N
6	68	ns1.example.com:hostmaster.expiry3.test	6	10800:3600:604800:5400	0	0	0	86400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	69	expiry3.test	2	ns2.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	70	expiry3.test	2	ns1.example.com	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	71	expiry3.test	1	10.0.0.4	0	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	72	expiry3.test	15	mx1.example.com	10	0	0	7200	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	73	www.expiry3.test	5	expiry3.test	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	74	expiry3.test	16	"v=spf1 a mx -all"	0	0	0	10800	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	75	nostamp1a.expiry3.test	16	target - expired	0	0	0	5400	\N	0		2026-01-29 14:00:00-05	t	t	\N
6	76	nostamp2a.expiry3.test	16	target - soon to expire	0	0	0	5400	\N	0		2026-01-31 14:00:00-05	t	t	\N
6	77	nostamp3a.expiry3.test	16	target - valid soon	0	0	0	5400	\N	0		2026-01-31 14:00:00-05	f	t	\N
6	78	nostamp4a.expiry3.test	16	target - already valid	0	0	0	5400	\N	0		2026-01-29 14:00:00-05	f	t	\N
6	79	nostamp1b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	80	nostamp2b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	81	nostamp3b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	82	nostamp4b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	83	expires1a.expiry3.test	16	target - no timestamp	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	84	expires2a.expiry3.test	16	target - expired	0	0	0	5400	\N	0		2026-01-29 14:00:00-05	t	t	\N
6	85	expires3a.expiry3.test	16	target - expires soon	0	0	0	5400	\N	0		2026-01-31 14:00:00-05	t	t	\N
6	86	expires4a.expiry3.test	16	target - valid soon	0	0	0	5400	\N	0		2026-01-31 14:00:00-05	f	t	\N
6	87	expires5a.expiry3.test	16	target - already valid	0	0	0	5400	\N	0		2026-01-29 14:00:00-05	f	t	\N
6	88	expires6a.expiry3.test	16	target - valid less soon	0	0	0	5400	\N	0		2026-01-29 14:00:00-05	f	t	\N
6	89	expires1b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	90	expires2b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	91	expires3b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	92	expires4b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	93	expires5b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
6	94	expires6b.expiry3.test	16	to change	0	0	0	5400	\N	0		1969-12-31 19:00:00-05	f	f	\N
\.


--
-- Name: records_record_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.records_record_id_seq', 94, true);


--
-- Data for Name: rectypes; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.rectypes (val, name, stdflag, listorder, alphaorder) FROM stdin;
1	A	1	1	1
2	NS	2	10	37
3	MD	5	255	29
4	MF	5	255	30
5	CNAME	2	12	9
6	SOA	0	0	53
7	MB	5	255	28
8	MG	5	255	31
9	MR	5	255	33
10	NULL	5	255	43
11	WKS	5	255	64
12	PTR	3	5	46
13	HINFO	5	255	18
14	MINFO	5	255	32
15	MX	1	11	34
16	TXT	2	13	60
17	RP	4	255	48
18	AFSDB	5	255	4
19	X25	5	255	65
20	ISDN	5	255	21
21	RT	5	255	50
22	NSAP	5	255	38
23	NSAP-PTR	5	255	39
24	SIG	5	255	51
25	KEY	5	255	23
26	PX	5	255	47
27	GPOS	5	255	17
28	AAAA	1	3	3
29	LOC	5	255	25
30	NXT	5	255	44
31	EID	5	255	15
32	NIMLOC	5	255	36
33	SRV	1	14	55
34	ATMA	5	255	6
35	NAPTR	5	255	35
36	KX	5	255	24
37	CERT	5	255	8
38	A6	5	3	2
39	DNAME	5	255	12
40	SINK	5	255	52
41	OPT	5	255	45
42	APL	5	255	5
43	DS	5	255	14
44	SSHFP	5	255	56
45	IPSECKEY	5	255	20
46	RRSIG	5	255	49
47	NSEC	5	255	40
48	DNSKEY	5	255	13
49	DHCID	5	255	10
50	NSEC3	5	255	41
51	NSEC3PARAM	5	255	42
52	TLSA	5	255	255
53	SMIMEA	5	255	255
55	HIP	5	255	19
56	NINFO	5	255	255
57	RKEY	5	255	255
58	TALINK	5	255	255
59	CDS	5	255	255
60	CDNSKEY	5	255	255
61	OPENPGPKEY	5	255	255
62	CSYNC	5	255	255
63	ZONEMD	255	255	255
64	SVCB	255	255	255
65	HTTPS	255	255	255
99	SPF	5	255	54
100	UINFO	5	255	62
101	UID	5	255	61
102	GID	5	255	16
103	UNSPEC	5	255	63
104	NID	5	255	255
105	L32	5	255	255
106	L64	5	255	255
107	LP	5	255	255
108	EUI48	5	255	255
109	EUI64	5	255	255
249	TKEY	5	255	58
250	TSIG	5	255	59
251	IXFR	5	255	22
252	AXFR	5	255	7
253	MAILB	5	255	27
254	MAILA	5	255	26
255	*	5	255	255
256	URI	5	255	255
258	AVC	5	255	255
259	DOA	255	255	255
260	AMTRELAY	255	255	255
32768	TA	5	255	57
32769	DLV	5	255	11
65280	A+PTR	2	2	2
65281	AAAA+PTR	2	4	4
65282	PTR template	3	6	2
65283	A+PTR template	2	7	2
65284	AAAA+PTR template	2	8	2
65285	Delegation	2	9	2
65300	ALIAS	2	16	255
257	CAA	1	17	255
\.


--
-- Data for Name: refresh_zones; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.refresh_zones (zone, view, export_stamp, reftype) FROM stdin;
example.com		1765992286	add
example.org	ac	1765992379	add
example.net	ab	1765992395	add
expiry1.test		1765992408	add
2.168.192.in-addr.arpa		1765992449	add
\.


--
-- Data for Name: revzones; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.revzones (rdns_id, revnet, group_id, description, status, zserial, sertype, changed, default_location) FROM stdin;
1	192.168.2.0/24	1		1	2026010700	D	t	
\.


--
-- Name: revzones_rdns_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.revzones_rdns_id_seq', 1, true);


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: dnstest
--

COPY public.users (user_id, group_id, username, password, firstname, lastname, phone, type, status, permission_id, inherit_perm) FROM stdin;
1	1	admin	$1$PfEBUv9d$wV2/UG4gmKk08DLmdE8/d.	Initial	User	\N	S	1	2	f
\.


--
-- Name: users_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dnstest
--

SELECT pg_catalog.setval('public.users_user_id_seq', 1, true);


--
-- Name: default_records default_records_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.default_records
    ADD CONSTRAINT default_records_pkey PRIMARY KEY (record_id);


--
-- Name: domains domains_domain_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.domains
    ADD CONSTRAINT domains_domain_id_key UNIQUE (domain_id);


--
-- Name: domains domains_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.domains
    ADD CONSTRAINT domains_pkey PRIMARY KEY (domain, default_location);


--
-- Name: groups groups_group_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.groups
    ADD CONSTRAINT groups_group_id_key UNIQUE (group_id);


--
-- Name: locations locations_loc_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.locations
    ADD CONSTRAINT locations_loc_id_key UNIQUE (loc_id);


--
-- Name: locations locations_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.locations
    ADD CONSTRAINT locations_pkey PRIMARY KEY (location);


--
-- Name: permissions permissions_group_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT permissions_group_id_key UNIQUE (group_id);


--
-- Name: permissions permissions_permission_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT permissions_permission_id_key UNIQUE (permission_id);


--
-- Name: permissions permissions_user_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT permissions_user_id_key UNIQUE (user_id);


--
-- Name: records records_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.records
    ADD CONSTRAINT records_pkey PRIMARY KEY (record_id);


--
-- Name: rectypes rectypes_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.rectypes
    ADD CONSTRAINT rectypes_pkey PRIMARY KEY (val, name);


--
-- Name: refresh_zones refresh_zones_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.refresh_zones
    ADD CONSTRAINT refresh_zones_pkey PRIMARY KEY (zone, view);


--
-- Name: revzones revzones_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.revzones
    ADD CONSTRAINT revzones_pkey PRIMARY KEY (revnet, default_location);


--
-- Name: revzones revzones_rdns_id_key; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.revzones
    ADD CONSTRAINT revzones_rdns_id_key UNIQUE (rdns_id);


--
-- Name: users uidu; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT uidu UNIQUE (user_id);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (username);


--
-- Name: dom_status_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX dom_status_index ON public.domains USING btree (status);


--
-- Name: log_domain_id_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX log_domain_id_index ON public.log USING btree (domain_id);


--
-- Name: log_group_id_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX log_group_id_index ON public.log USING btree (group_id);


--
-- Name: log_rdns_id_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX log_rdns_id_index ON public.log USING btree (rdns_id);


--
-- Name: log_user_id_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX log_user_id_index ON public.log USING btree (user_id);


--
-- Name: rec_domain_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX rec_domain_index ON public.records USING btree (domain_id);


--
-- Name: rec_revzone_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX rec_revzone_index ON public.records USING btree (rdns_id);


--
-- Name: rec_types_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX rec_types_index ON public.records USING btree (type);


--
-- Name: rev_status_index; Type: INDEX; Schema: public; Owner: dnstest
--

CREATE INDEX rev_status_index ON public.revzones USING btree (status);


--
-- Name: domains $1; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.domains
    ADD CONSTRAINT "$1" FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- Name: default_records $1; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.default_records
    ADD CONSTRAINT "$1" FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- Name: users $1; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT "$1" FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- Name: revzones $1; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.revzones
    ADD CONSTRAINT "$1" FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- Name: groups group_parent; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.groups
    ADD CONSTRAINT group_parent FOREIGN KEY (parent_group_id) REFERENCES public.groups(group_id);


--
-- Name: locations locations_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dnstest
--

ALTER TABLE ONLY public.locations
    ADD CONSTRAINT locations_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- PostgreSQL database dump complete
--

