-- SQL upgrade file for dnsadmin 1.2.3 to 1.2.4 bugfix update

-- pre-pg8.3, this must be run as a superuser
CREATE LANGUAGE plpgsql;
-- it's required for:

-- Return proper conversion of string to inet, or 0.0.0.0/0 if the string is
-- not a valid inet value.  We need to do this to support "funky" records that
-- may not actually have valid IP address values.  Used for ORDER BY
CREATE OR REPLACE FUNCTION inetlazy (rdata text) RETURNS inet AS $$
BEGIN
	RETURN CAST(rdata AS inet);
EXCEPTION
	WHEN OTHERS THEN
		RETURN CAST('0.0.0.0/0' AS inet);
END;
$$ LANGUAGE plpgsql;

-- Update dbversion
UPDATE misc SET value='1.2.4' WHERE key='dbversion';
