-- Updates introduced in 1.4.0 schema

-- Cross-reference field for collapsing large blocks of related log entries
ALTER TABLE log ADD COLUMN logparent integer;
-- As a separate statement Just In Case
UPDATE log SET logparent = 0;
ALTER TABLE log ALTER COLUMN logparent SET DEFAULT 0;
ALTER TABLE log ALTER COLUMN logparent SET NOT NULL;
CREATE INDEX log_logparent_index ON log(logparent);

-- Missing indexes on the log table;  should shave the search/filter
-- time somewhat on large installs.
CREATE INDEX log_domain_id_index ON log(domain_id);
CREATE INDEX log_user_id_index ON log(user_id);
CREATE INDEX log_group_id_index ON log(group_id);
CREATE INDEX log_rdns_id_index ON log(rdns_id);

-- Matching index on revzones
CREATE INDEX revzones_rdns_id_index ON revzones(rdns_id);

-- Update dbversion
UPDATE misc SET value='1.4.0' WHERE key='dbversion';
