#!/usr/bin/perl -w -T
# Plaintext record list for DeepNet DNS Administrator
##
# $Id: textrecs.cgi 756 2017-06-13 17:58:57Z kdeugau $
# Copyright 2012-2014 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;

use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use CGI::Session;
use DBI;

# don't remove!  required for GNU/FHS-ish install from tarball
use lib '.';	##uselib##

use DNSDB;

# Let's do these templates right...
my $templatedir = "templates";

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
my %webvar = $q->Vars;

# shut up some warnings, in case we arrive somewhere we forgot to set this
$webvar{defrec} = 'n' if !$webvar{defrec};	# non-default records
$webvar{revrec} = 'n' if !$webvar{revrec};	# non-reverse (domain) records

my $dnsdb = new DNSDB;

# Check the session and if we have a zone ID to retrieve.  Call a failure sub if not.
my $sid = $q->cookie('dnsadmin_session');
my $session = new CGI::Session("driver:File", $sid, {Directory => $dnsdb->{sessiondir}})
	or die CGI::Session->errstr();
do_not_pass_go() if !$sid;
do_not_pass_go() if !$webvar{id};

my $zone;
$zone = ($webvar{revrec} eq 'n' ? $dnsdb->domainName($webvar{id}) : $dnsdb->revName($webvar{id}))
	if $webvar{defrec} eq 'n';
$zone = "group ".$dnsdb->groupName($webvar{id}) if $webvar{defrec} eq 'y';

##fixme:  do we support both HTML-plain and true plaintext?  could be done, with another $webvar{}
# Don't die on bad parameters.  Saves munging the return from getRecList.
#my $page = HTML::Template->new(filename => "$templatedir/textrecs.tmpl",
#	loop_context_vars => 1, global_vars => 1, die_on_bad_params => 0);
#print "Content-type: text/html\n\n";

print "Content-type: text/plain\n\n";
print "Plaintext version of records for $zone.\n" if $webvar{defrec} eq 'n';
print "Plaintext version of default ".($webvar{revrec} eq 'y' ? 'reverse ' : '')."records for $zone.\n"
	if $webvar{defrec} eq 'y';
print qq(Press the "Back" button to return to the standard record list.\n\n);

my $reclist = $dnsdb->getRecList(defrec => $webvar{defrec}, revrec => $webvar{revrec}, id => $webvar{id},
	sortby => ($webvar{revrec} eq 'n' ? 'type,host' : 'type,val'), sortorder => 'ASC', offset => 'all');
foreach my $rec (@$reclist) {
  $rec->{type} = $typemap{$rec->{type}};
  $rec->{val} .= '.' if $rec->{type} ne 'A' && $rec->{type} ne 'TXT' && $webvar{revrec} eq 'n' && $rec->{val} !~ /\.$/;
  $rec->{host} .= '.' if $webvar{revrec} eq 'y' && $rec->{val} !~ /\.$/;
  $rec->{val} = "$rec->{distance}  $rec->{val}" if $rec->{type} eq 'MX';
  $rec->{val} = "$rec->{distance}  $rec->{weight}  $rec->{port}  $rec->{val}" if $rec->{type} eq 'SRV';
  if ($webvar{revrec} eq 'y') {
    printf "%-16s\t%d\t%s\t%s\n", $rec->{val}, $rec->{ttl}, $rec->{type}, $rec->{host};
  } else {
    printf "%-45s\t%d\t%s\t%s\n", $rec->{host}, $rec->{ttl}, $rec->{type}, $rec->{val};
  }
}
#$page->param(defrec => ($webvar{defrec} eq 'y'));
#$page->param(revrec => ($webvar{revrec} eq 'y'));
#$page->param(zone => $zone);
#$page->param(reclist => $reclist);
#$page->param(fwdzone => ($webvar{revrec} eq 'n'));
#print $page->output;

exit;

sub do_not_pass_go {
  my $webpath = $ENV{SCRIPT_NAME};
  $webpath =~ s|/[^/]+$|/|;
  print "Status: 302\nLocation: http://$ENV{HTTP_HOST}$webpath\n\n";
  exit;
}
