#!/usr/bin/perl
# Import script for VegaDNS data
# $Id: vega-import.pl 171 2011-11-25 23:02:28Z kdeugau $
# Copyright (C) 2011 Kris Deugau <kdeugau@deepnet.cx>

# Runs in one of two modes:
# - Wipe the contents and import the VegaDNS data with (almost) all entity-ID info as-is
# - Add the contents to the current DB, as a subgroup of the root parent group 1

use strict;
use warnings;

use DBI;
use Data::Dumper;

use DNSDB qw(:ALL);

if (!loadConfig()) {
  warn "Using default configuration;  unable to load custom settings: $DNSDB::errstr";
}

my $mode = 'add';

if ($ARGV[0] && $ARGV[0] !~ /^(add|replace)$/) {
  die "Usage:  vega-import.pl [add|replace]\n".
	"	add	 Import VegaDNS data as a subgroup of the default root group\n".
	"	replace	 Wipe all existing data and import VegaDNS data into the root group\n";
}

$mode = $ARGV[0] if $ARGV[0];

my ($newdbh,$msg) = connectDB($config{dbname}, $config{dbuser}, $config{dbpass}, $config{dbhost});
$newdbh->{PrintError} = 1;
$newdbh->{PrintWarn} = 1;

if ($mode eq 'replace') {
  print "WARNING:  Using 'replace' will **DELETE** all existing group,\n".
	"user, domain, and record data.  Once started this cannot be\n".
	"reversed.  Enter 'yes' to proceed: ";
  my $resp = <STDIN>;
  chomp $resp;
  if ($resp ne 'yes') {
    print "Aborting;  no changes made.\n";
    exit;
  } else {
    print "OK, continuing.\n";
    $newdbh->do("DELETE FROM users") or warn "error deleting users: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM log") or warn "error deleting log: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM default_records") or warn "error deleting defrecs: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM records") or warn "error deleting records: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM domains") or warn "error deleting domains: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM groups") or warn "error deleting groups: ".$newdbh->errstr."\n";
    $newdbh->do("DELETE FROM permissions") or warn "error deleting permissions: ".$newdbh->errstr."\n";
    # set seq id on permissions, since we merged the two tables, and the new permission IDs will not match the old
    $newdbh->do("SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('permissions', 'permission_id'),".
	"1, true)") or warn "couldn't set permission sequence: ".$newdbh->errstr."\n";
  }
}

my $vegadbh = DBI->connect('DBI:mysql:database=vegadns;host=localhost', 'vegadns', 'secret', {
	PrintError => 1,
	PrintWarn => 1,
	AutoCommit => 1
  });

my $grpsubs = $vegadbh->prepare("SELECT group_id FROM groups ORDER BY group_id");
my $grpdata = $vegadbh->prepare("SELECT group_id, parent_group_id, name FROM groups WHERE group_id=?");
my $grppget = $vegadbh->prepare("SELECT perm_id,inherit_group_perms,accouedit,accoucreate,accoudelete,".
	"self_edit,group_edit,group_create,group_delete,domain_edit,domain_create,domain_delete,record_edit,".
	"record_create,record_delete FROM group_permissions WHERE group_id=?");
my $userget = $vegadbh->prepare("SELECT user_id, group_id, email, password, first_name, last_name, phone, ".
	"account_type, status FROM accounts WHERE group_id=?");
my $userpget = $vegadbh->prepare("SELECT perm_id,inherit_group_perms,accouedit,accoucreate,accoudelete,".
	"self_edit,group_edit,group_create,group_delete,domain_edit,domain_create,domain_delete,record_edit,".
	"record_create,record_delete FROM user_permissions WHERE user_id=?");

my $newgrp = $newdbh->prepare("INSERT INTO groups (group_id,parent_group_id,group_name,permission_id) ".
	"VALUES (?,?,?,?)");
my $newgrppset = $newdbh->prepare("INSERT INTO permissions (self_edit, group_create, ".
	"group_edit, group_delete, user_create, user_edit, user_delete, domain_create, domain_edit, ".
	"domain_delete, record_create, record_edit, record_delete, group_id) ".
	"VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
my $newpid = $newdbh->prepare("SELECT currval('permissions_permission_id_seq')");
my $newuser = $newdbh->prepare("INSERT INTO users (user_id, group_id, username, password, firstname, ".
	"lastname, phone, type, status, permission_id, inherit_perm) VALUES (?,?,?,?,?,?,?,?,?,?,'f')");
my $newuserpset = $newdbh->prepare("INSERT INTO permissions (self_edit, group_create, ".
	"group_edit, group_delete, user_create, user_edit, user_delete, domain_create, domain_edit, ".
	"domain_delete, record_create, record_edit, record_delete, user_id) ".
	"VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

my $foo = qq(

perm_id | group_id | inherit_group_perms | accouedit | accoucreate | accoudelete | self_edit | group_edit | 
group_create | group_delete | domain_edit | domain_create | domain_delegate | domain_delete | record_edit | 
record_create | record_delete | record_delegate | default_record_edit | default_record_create | 
default_record_delete | rrtype_allow_n | rrtype_allow_a | rrtype_allow_3 | rrtype_allow_6 | rrtype_allow_m | 
rrtype_allow_p | rrtype_allow_t | rrtype_allow_v | rrtype_allow_all

permission_id | admin | self_edit | group_create | group_edit | group_delete | user_create | user_edit | 
user_delete | domain_create | domain_edit | domain_delete | record_create | record_edit | record_delete | 
user_id | group_id

);

my $stage = 'start';
$grpsubs->execute;
my $grp = 0;
while (($grp) = $grpsubs->fetchrow_array()) {
  dogroup($grp);
}
# set group seq to $grp+1
exit;

sub dogroup {
  my $grpid = shift;
  $grpdata->execute($grpid) or warn $grpdata->errstr;
  my $oldgrp = $grpdata->fetchrow_hashref() or warn $grpdata->errstr;
  print "group id $grpid, name $oldgrp->{name}\n";

  $grppget->execute($grpid) or warn $grppget->errstr;
  my $oldp = $grppget->fetchrow_hashref() or warn $grppget->errstr;

  # de-nullify
  foreach my $permtype ('self_edit', 'group_create', 'group_edit', 'group_delete', 'user_create',
	'user_edit', 'user_delete', 'domain_create', 'domain_edit', 'domain_delete', 'record_create',
	'record_edit', 'record_delete') {
    $oldp->{$permtype} = 'f' if !defined($oldp->{$permtype});
  }
  $newgrppset->execute($oldp->{self_edit}, $oldp->{group_create}, $oldp->{group_edit}, $oldp->{group_delete},
	$oldp->{user_create}, $oldp->{user_edit}, $oldp->{user_delete},
	$oldp->{domain_create}, $oldp->{domain_edit}, $oldp->{domain_delete},
	$oldp->{record_create}, $oldp->{record_edit}, $oldp->{record_delete},
	$grpid) or warn $newgrppset->errstr;
  $newpid->execute;
  my ($pid) = $newpid->fetchrow_array;
  $newgrp->execute($grpid, $oldgrp->{parent_group_id}, $oldgrp->{name}, $pid);

 ## Users
  print " users:\n";
  $userget->execute($grpid);
  while (my $user = $userget->fetchrow_hashref) {
    $userpget->execute($user->{user_id}) or warn "failed permission get on ".$user->{user_id}."\n";
    my $oldp = $userpget->fetchrow_hashref;
    # de-nullify
    foreach my $permtype ('self_edit', 'group_create', 'group_edit', 'group_delete', 'user_create',
	'user_edit', 'user_delete', 'domain_create', 'domain_edit', 'domain_delete', 'record_create',
	'record_edit', 'record_delete') {
      $oldp->{$permtype} = 'f' if !defined($oldp->{$permtype});
    }
    $newuserpset->execute($oldp->{self_edit}, $oldp->{group_create}, $oldp->{group_edit}, $oldp->{group_delete},
	$oldp->{user_create}, $oldp->{user_edit}, $oldp->{user_delete},
	$oldp->{domain_create}, $oldp->{domain_edit}, $oldp->{domain_delete},
	$oldp->{record_create}, $oldp->{record_edit}, $oldp->{record_delete},
	$user->{user_id}) or warn $newgrppset->errstr;
    $newpid->execute;
    my ($pid) = $newpid->fetchrow_array;
    # fiddle user data
    $user->{account_type} = 'S' if $user->{account_type} eq 'senior_admin';
    $user->{account_type} = 'u' if $user->{account_type} eq 'user';
    $user->{status} = ($user->{status} eq 'active' ? 1 : 0);
    $newuser->execute($user->{user_id}, $user->{group_id}, $user->{email}, $user->{password},
	$user->{first_name}, $user->{last_name}, $user->{phone}, $user->{account_type}, $user->{status}, $pid) 
	or warn "  new user ".$user->{email}." (".$user->{user_id}.") failed: ".$newuser->errstr."\n";
    print " user ".$user->{email}." (".$user->{user_id}.")\n";
  }


}
