# spec file for DNS Administrator
# $Id: dnsadmin.spec 221 2012-01-16 21:48:34Z kdeugau $

# A collection of magic for packaging with debbuild (https://secure.deepnet.cx/trac/debbuild
# Sets the release "number" such that dist upgrades will upgrade in the right order.
%if "%{debdist}" == "sarge"
%define errata 0
%endif
%if "%{debdist}" == "dapper"
%define errata 1
%endif
%if "%{debdist}" == "etch"
%define errata 2
%endif
%if "%{debdist}" == "lenny"
%define errata 3
%endif
%if "%{debdist}" == "squeeze"
%define errata 4
%endif
%if %{?relnum:0}%{?!relnum:1}
%define relnum 1
%endif

# redefine release only if debdist is defined
%if %{?debdist:1}%{?!debdist:0}
%define release %{relnum}.%{errata}%{debdist}
%else
%define release 1
%endif

# handle flag for parallel-versions installs.
%if %{?para_versions:1}%{?!para_versions:0}
%define pkg_leaf dnsdb-%{version}
%define cfg_leaf dnsdb/%{version}
%else
%define pkg_leaf dnsdb
%define cfg_leaf dnsdb
%endif

Summary: DeepNet DNS Administrator
Name: dnsadmin
Version: #VERSION#
Release: %{release}
Group: Applications/System
Source: %{name}-%{version}.tar.gz
Packager: Kris Deugau <kdeugau@deepnet.cx>
BuildRoot: /var/tmp/%{name}-%{version}
License: GPL 3+
BuildArch: noarch

# not absolutely required:
Requires: perl(NetAddr::IP) >= 4

# rpmbuild should fill in the rest of the deps.  Debian's tools aren't so friendly.  :/

%if %{_vendor} == "debbuild"
# ah, Debian, how we do *love* thee so...  *eyeroll*
Requires: libfrontier-rpc-perl >= 0.07b4, perl(CGI::Simple), perl(HTML::Template), perl(Net::DNS)
Requires: perl(CGI::Session), perl(Crypt::PasswdMD5), perl(Digest::MD5), perl(Net::Whois::Raw)
%endif

%description
A web-based DNS management tool

%prep
%setup

%build

%install
# le sigh.  rpm's makeinstall macro includes the buildroot in the dirs, so it will break here.  :/
make \
        prefix=%{_prefix} \
        exec_prefix=%{_exec_prefix} \
        bindir=%{_bindir} \
        sbindir=%{_sbindir} \
        sysconfdir=%{_sysconfdir} \
        datadir=%{_datadir} \
        includedir=%{_includedir} \
        libdir=%{_libdir} \
        libexecdir=%{_libexecdir} \
        localstatedir=%{_localstatedir} \
        sharedstatedir=%{_sharedstatedir} \
        mandir=%{_mandir} \
        infodir=%{_infodir} \
  install DESTDIR=$RPM_BUILD_ROOT PARA_VERSIONS=%{?para_versions:1}%{?!para_versions:0}

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]; then
  rm -rf $RPM_BUILD_ROOT
fi

%files
%dir %{_datadir}/%{pkg_leaf}
%attr(-,-,0755) %{_datadir}/%{pkg_leaf}/*.cgi
%attr(-,-,0755) %{_datadir}/%{pkg_leaf}/*.pl
%{_datadir}/%{pkg_leaf}/DNSDB.pm
%{_datadir}/%{pkg_leaf}/images
%{_datadir}/%{pkg_leaf}/templates
%dir %{_sysconfdir}/%{cfg_leaf}
%config %{_sysconfdir}/%{cfg_leaf}/dnsdb.conf

%changelog
* Fri Jan 13 2012  Kris Deugau <kdeugau@deepnet.cx> 1.0-1
- Initial package
