#!/usr/bin/perl -w -T
# dns/cgi-bin/dns.cgi
###
# SVN revision info
# $Date: 2009-09-01 21:07:57 +0000 (Tue, 01 Sep 2009) $
# SVN revision $Rev: 5 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2008,2009 - Kris Deugau <kdeugau@deepnet.cx>

use strict;
use warnings;

use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use CGI::Session;
use DBI;

use lib '.';
# custom modules
use DNSDB qw(:ALL);

# Let's do these templates right...
my $templatedir = "templates";
my $sessiondir = "session";

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

my $sid = ($webvar{sid} ? $webvar{sid} : undef);
my $session = new CGI::Session("driver:File", $sid, {Directory => $sessiondir});
#$sid = $session->id() if !$sid;
if (!$sid) {
  # init stuff.  can probably axe this down to just above if'n'when user manipulation happens
  $sid = $session->id();
# need to know the "upper" group the user can deal with;  may as well
# stick this in the session rather than calling out to the DB every time.
  $session->param('logingroupid',1);
  $session->param('workinggroupid',1);	# yes, we *do* need to track this too.  er, probably.
}

# handle login redirect
if ($webvar{action} && $webvar{action} eq 'login') {
  # handle user check
  my $newurl = "http://$ENV{HTTP_HOST}$ENV{REQUEST_URI}?sid=$sid&page=domlist";
  print "Status: 302\nLocation: $newurl\n\n";
  exit;
}

my $header = HTML::Template->new(filename => "$templatedir/header.tmpl");
my $footer = HTML::Template->new(filename => "$templatedir/footer.tmpl");

## hmm.  may want to move this so we can redirect after adding/deleting/etc
print "Content-type: text/html\n\n", $header->output;

# default
#my $perpage = 15;
my $perpage = 3;
my $offset = ($webvar{offset} ? $webvar{offset} : 0);

# NB:  these must match the field name and SQL ascend/descend syntax respectively
my $sortfield = "domains";
my $sortorder = "asc";

my ($dbh,$msg) = connectDB("dnsdb","dnsdb","secret");
#my $dbh = DBI->connect("DBI:mysql:database=vegadns","vegadns","secret",
#	{ AutoCommit => 0 }) or die $DBI::errstr;

##fixme.  PLEASE!  <G>
print $msg if !$dbh;

# fiddle hardcoded "defaults" as per system/user (?) prefs
initGlobals($dbh);

# Default page is a login page
my $page;	# to be initialized as an HTML::Template entity sooner or later



# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "$templatedir/login.tmpl");
} else {
  $page = HTML::Template->new(filename => "$templatedir/$webvar{page}.tmpl");
}

$page->param(sid => $sid);

if ($webvar{page} eq 'domlist' or $webvar{page} eq 'index') {

# hmm.  seeing problems in some possibly-not-so-corner cases.
  if (defined($webvar{action})) {
    domStatus($dbh,$webvar{id},$webvar{action});
  }

  my $sth = $dbh->prepare("select count(*) from domains");
  $sth->execute;
  my ($count) = ($sth->fetchrow_array);

##fixme
  if ($offset eq 'all') {
    print "foo!  wanna see'em all\n";
  } else {
    # all these bits only have sensible behaviour if offset is numeric. err, probably.
    if ($count > $perpage) {
      # if there are more results than the default, always show the "all" link
      $page->param(navall => 1);

      if ($offset > 0) {
        $page->param(navfirst => 1);
        $page->param(navprev => 1);
        $page->param(prevoffs => $offset-1);
      }

      # show "next" and "last" links if we're not on the last page of results
      if ( (($offset+1) * $perpage - $count) < 0 ) {
        $page->param(navnext => 1);
        $page->param(nextoffs => $offset+1);
        $page->param(navlast => 1);
        $page->param(lastoffs => int $count/$perpage);
      }
    }
  }

  $page->param(ndomains => $count);
  $page->param(nstart => (($offset eq 'all' ? 0 : $offset)*$perpage+1));
  $page->param(npglast => ($offset eq 'all' ? $count :
	( (($offset+1)*$perpage) > $count ? $count : (($offset+1)*$perpage) )
	));
##fixme
  $page->param(id => 1);
  my @domlist;
  $sth = $dbh->prepare("select domain_id,domain,status,groups.name from domains".
	" inner join groups on domains.group_id=groups.group_id".
	" order by domain".($offset eq 'all' ? '' : " limit $perpage offset ".$offset*$perpage));
  $sth->execute;
  my $rownum = 0;
  while (my @data = $sth->fetchrow_array) {
    my %row;
    $row{domainid} = $data[0];
    $row{domain} = $data[1];
    $row{status} = ($data[2] ? 'Active' : 'Inactive');
    $row{group} = $data[3];
    $row{bg} = ($rownum++)%2;
#    $row{mkactive} = ($data[2] eq 'inactive' ? 1 : 0);
    $row{mkactive} = !$data[2];
    $row{sid} = $sid;
    $row{offset} = $offset;
##fixme:  need to clean up status indicator/usage/inversion
    push @domlist, \%row;
  }
  $page->param(domtable => \@domlist);

} elsif ($webvar{page} eq 'reclist') {

  # Handle record list for both default records (per-group) and live domain records

  $page->param(defrec => $webvar{defrec});
  $page->param(id => $webvar{id});
  $page->param(curpage => 'reclist');

# select count(*) from (default_)?records where (group|domain)_id=?
    my $sth = $dbh->prepare("SELECT count(*) FROM ".
	($webvar{defrec} eq 'y' ? 'default_' : '')."records ".
	"WHERE ".($webvar{defrec} eq 'y' ? 'group' : 'domain')."_id=? ".
	"AND NOT type=$reverse_typemap{SOA}");
    $sth->execute($webvar{id});
    my ($count) = ($sth->fetchrow_array);

  $page->param(ntot => $count);
  $page->param(nfirst => 1);
  $page->param(nlast => 10);

##fixme
  if ($offset eq 'all') {
    print "foo!  wanna see'em all\n";
  } else {
    # all these bits only have sensible behaviour if offset is numeric. err, probably.
    if ($count > $perpage) {
      # if there are more results than the default, always show the "all" link
      $page->param(navall => 1);

      if ($offset > 0) {
        $page->param(navfirst => 1);
        $page->param(navprev => 1);
        $page->param(prevoffs => $offset-1);
      }

      # show "next" and "last" links if we're not on the last page of results
      if ( (($offset+1) * $perpage - $count) < 0 ) {
        $page->param(navnext => 1);
        $page->param(nextoffs => $offset+1);
        $page->param(navlast => 1);
        $page->param(lastoffs => int $count/$perpage);
      }
    }
  }

##fixme
  $page->param(domain => domainName($dbh,$webvar{id}));
  $page->param(id => $webvar{id});
##fixme

  $page->param(defrec => $webvar{defrec});
  if ($webvar{defrec} eq 'y') {
    showdomain('y',1);
  } else {
    showdomain('n',$webvar{id});
  }

} elsif ($webvar{page} eq 'newdomain') {

  # weesa gonna discard parent_group_id for now
  my $sth = $dbh->prepare("select group_id,parent_group_id,name from groups order by group_id");
  $sth->execute;
  my @grplist;
  while (my ($grpid,$pargrp,$grpname) = $sth->fetchrow_array()) {
    my %row;
    $row{grpname} = $grpname;
    $row{grpval} = $grpid;
##fixme: need magic
#    $row{defgrp} = '';
    push @grplist, \%row;
  }

  $page->param(grplist => \@grplist);

} elsif ($webvar{page} eq 'newrec') {
  print "whee!\n";

  # populate most fields as needed.  (eg, type list.)
  newrec();

} elsif ($webvar{page} eq 'addrec') {

  my @recargs = ($dbh,$webvar{defrec},$webvar{parentid},$webvar{name},$webvar{type},$webvar{address},$webvar{ttl});
  if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV}) {
    push @recargs, $webvar{distance};
    if ($webvar{type} == $reverse_typemap{SRV}) {
      push @recargs, $webvar{weight};
      push @recargs, $webvar{port};
    }
  }
  push @recargs, 
  my ($code,$msg) = addRec(@recargs);

  if ($code eq 'OK') {
    showdomain($webvar{defrec},$webvar{parentid});
# NB: should **really** redirect here, in case of reload.  >_<  eyowch.
  } else {
    $page->param(add_failed => 1);
    $page->param(errmsg => $msg);
    newrec();	# populate the form... er, mostly.
    $page->param(name => $webvar{name});
    $page->param(address => $webvar{address});
    $page->param(distance => $webvar{distance})
	if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV});
    $page->param(weight => $webvar{weight}) if $webvar{type} == $reverse_typemap{SRV};
    $page->param(port => $webvar{port}) if $webvar{type} == $reverse_typemap{SRV};
  }

  $page->param(defrec => $webvar{defrec});

} elsif ($webvar{page} eq 'conf_del') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});

  my @tmp = getrecdata($dbh,$webvar{id},$webvar{defrec});

} elsif ($webvar{page} eq 'delrec') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
    my %rec = getRecLine($dbh,$webvar{defrec},$webvar{id});
    $page->param(host => $rec{host});
    $page->param(ftype => $typemap{$rec{type}});
    $page->param(recval => $rec{val});
  } else {
    my ($code,$msg) = delRec($dbh,$webvar{defrec},$webvar{id});
    if ($code ne 'OK') {
## need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
    }
##fixme:  group/parent instead of hardcoded 1
    showdomain('y',1);
  }

} elsif ($webvar{page} eq 'deldom') {

  $page->param(id => $webvar{id});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
    $page->param(domain => domainName($dbh,$webvar{id}));
# print some neato things?
  } elsif ($webvar{del} eq 'ok') {
    my ($code,$msg) = delDomain($dbh, $webvar{id});
    if ($code ne 'OK') {
# need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
    }
  } else {
    # cancelled.  whee!
    $page->param(del_failed => 0);
# more params?
  }

} elsif ($webvar{page} eq 'editsoa') {

  fillsoa($webvar{defrec},$webvar{recid});

} elsif ($webvar{page} eq 'updatesoa') {
  print "ooooo!\n";

  my $sth;
  my $sql = '';
  # no domain ID, so we're editing the default SOA for a group (we don't care which one here)
  # plus a bit of magic to update the appropriate table
  $sql = "update ".($webvar{domainid} eq '' ? "default_records" : "records").
	" set host='$webvar{prins}:$webvar{contact}',".
	" val='$webvar{refresh}:$webvar{retry}:$webvar{expire}:$webvar{minttl}',".
	" ttl=$webvar{ttl} where record_id=$webvar{recid}";
  $sth = $dbh->prepare($sql);
  $sth->execute;

  if ($sth->err) {
    $page->param(update_failed => 1);
    $page->param(msg => $DBI::errstr);
    fillsoa($webvar{defrec},1);
  } else {
    $page->param(update_failed => 0);
##fixme!  need to set group ID properly here
    showdomain('y',1);
  }

} elsif ($webvar{page} eq 'adddomain') {
  # Need some magic here.

##fixme:  Group should be variable
  my ($code,$msg) = addDomain($dbh,$webvar{domain},1,($webvar{makeactive} eq 'on' ? 1 : 0));

# hokay, a bit of magic to decide which page we hit.
  if ($code eq 'OK') {
    $page = HTML::Template->new(filename => "$templatedir/reclist.tmpl");
    showdomain(0,$msg);
##work
  } else {
# oooh, yeah, this is supposed to be a redirect.  er, maybe.  whee.
    $page = HTML::Template->new(filename => "$templatedir/newdomain.tmpl");
    $page->param(add_failed => 1);
    $page->param(domain => $webvar{domain});
    $page->param(errmsg => $msg);
  }


}


# spit it out
print $page->output;

print "<div id=debug>webvar keys: <pre>\n";
foreach my $key (keys %webvar) {
  print "key: $key\tval: $webvar{$key}\n";
}
print "</pre>\nENV:\n<pre>\n";
foreach my $key (keys %ENV) {
  print "key: $key\tval: $ENV{$key}\n";
}
print "</pre></div>\n";

print $footer->output;


exit 0;


sub fillsoa {
  my $def = shift;
  my $id = shift;
  my $domname;

  if ($webvar{domain} == 0) {
    $domname = "DOMAIN";
  } else {
    my $sth = $dbh->prepare("select domain from domains where domain_id=$webvar{domain}");
    $sth->execute();
    ($domname) = $sth->fetchrow_array();
  }

  $page->param(domain => $domname);
  $page->param(defrec => !$webvar{domain});
  $page->param(group => $DNSDB::group);

# defaults
  $page->param(defcontact => $DNSDB::def{contact});
  $page->param(defns => $DNSDB::def{prins});
  $page->param(defsoattl => $DNSDB::def{soattl});
  $page->param(defrefresh => $DNSDB::def{refresh});
  $page->param(defretry => $DNSDB::def{retry});
  $page->param(defexpire => $DNSDB::def{expire});
  $page->param(defminttl => $DNSDB::def{minttl});

  # there are probably better ways to do this.  TMTOWTDI.
  my %soa = getSOA($dbh,$def,$id);

  $page->param(domainid	=> $webvar{domain});
  $page->param(recid	=> $soa{recid});
  $page->param(prins	=> ($soa{prins} ? $soa{prins} : $DNSDB::def{prins}));
  $page->param(contact	=> ($soa{contact} ? $soa{contact} : $DNSDB::def{contact}));
  $page->param(refresh	=> ($soa{refresh} ? $soa{refresh} : $DNSDB::def{refresh}));
  $page->param(retry	=> ($soa{retry} ? $soa{retry} : $DNSDB::def{retry}));
  $page->param(expire	=> ($soa{expire} ? $soa{expire} : $DNSDB::def{expire}));
  $page->param(minttl	=> ($soa{minttl} ? $soa{minttl} : $DNSDB::def{minttl}));
  $page->param(ttl	=> ($soa{ttl} ? $soa{ttl} : $DNSDB::def{soattl}));
}

sub showdomain {
  my $def = shift;
  my $id = shift;

  # get the SOA first
  my %soa = getSOA($dbh,$def,$id);

  $page->param(recid	=> $soa{recid});
  $page->param(contact	=> $soa{contact});
  $page->param(prins	=> $soa{prins});
  $page->param(refresh	=> $soa{refresh});
  $page->param(retry	=> $soa{retry});
  $page->param(expire	=> $soa{expire});
  $page->param(minttl	=> $soa{minttl});
  $page->param(ttl	=> $soa{ttl});

##fixme!
my $roffset = 0;

#  my @foo2 = getDomRecs($dbh,'def',1);
  my $foo2 = getDomRecs($dbh,$def,$id,$perpage,$webvar{offset});

#  $sth = $dbh->prepare("select domain_id,domain,status,groups.name from domains".
#	" inner join groups on domains.group_id=groups.group_id".
#	" order by domain".($offset eq 'all' ? '' : " limit $perpage offset ".$offset*$perpage));
#  $sth->execute;
#  my $rownum = 0;
#  while (my @data = $sth->fetchrow_array) {
#    my %row;
#    $row{domainid} = $data[0];
#    $row{domain} = $data[1];
#    $row{status} = ($data[2] ? 'Active' : 'Inactive');
#    $row{group} = $data[3];
#    $row{bg} = ($rownum++)%2;
##    $row{mkactive} = ($data[2] eq 'inactive' ? 1 : 0);
#    $row{mkactive} = !$data[2];
#    $row{sid} = $sid;
#    $row{offset} = $offset;

  my $row = 0;
  foreach my $rec (@$foo2) {
    $rec->{type} = $typemap{$rec->{type}};
    $rec->{row} = $row % 2;
    # Feh.
    $rec->{defrec} = $webvar{defrec};
    # And **FEH!!**
    $rec->{sid} = $webvar{sid};
    $row++;
  }
  $page->param(reclist => $foo2);
}

sub newrec {
  my $sth = $dbh->prepare("select val,name from rectypes where stdflag=1 order by listorder");
  $sth->execute;

  my @typelist;
  while (my ($rval,$rname) = $sth->fetchrow_array()) {
    my %row = ( recval => $rval, recname => $rname );
    $row{tselect} = 1 if $rval == $webvar{type};
    push @typelist, \%row;
  }
  $page->param(typelist	=> \@typelist);
  $page->param(domain	=> domainName($dbh,$webvar{domainid}));
  $page->param(defrec	=> $webvar{defrec});
  $page->param(ttl	=> ($webvar{ttl} ? $webvar{ttl} : $DNSDB::def{minttl}));
  if ($webvar{defrec} eq 'y') {
    ##fixme - should be groupid
    $page->param(parentid => 1);
  } else {
print "DEBUG: foobar:  parentid $webvar{parentid}<br>\n";
    $page->param(parentid => $webvar{parentid});
  }
}
