-- SQL to update DNS DB schema for 1.2.6

-- Allow zones to be duplicated, so long as each version is in a unique location
ALTER TABLE ONLY domains
    DROP CONSTRAINT domains_pkey;
ALTER TABLE ONLY domains
    ADD PRIMARY KEY (domain,default_location);

ALTER TABLE ONLY revzones
    DROP CONSTRAINT revzones_pkey;
ALTER TABLE ONLY revzones
    ADD PRIMARY KEY (revnet,default_location);

-- MIA unique constraint to match domains table.  Arguably not strictly necessary.
ALTER TABLE ONLY revzones
    ADD CONSTRAINT revzones_rdns_id_key UNIQUE (rdns_id);

-- Update dbversion
UPDATE misc SET value='1.2.6' WHERE key='dbversion';
