#!/usr/bin/perl -w -T
# dns/cgi-bin/dns.cgi
###
# SVN revision info
# $Date: 2009-08-17 17:43:40 +0000 (Mon, 17 Aug 2009) $
# SVN revision $Rev: 2 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2008 - Kris Deugau <kdeugau@deepnet.cx>

use strict;
use warnings;

use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use CGI::Session;
use DBI;

use lib '.';
# custom modules
use DNSDB qw(:ALL);

# Let's do these templates right...
my $templatedir = "templates";
my $sessiondir = "session";

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

my $sid = ($webvar{sid} ? $webvar{sid} : undef);
my $session = new CGI::Session("driver:File", $sid, {Directory => $sessiondir});
#$sid = $session->id() if !$sid;
if (!$sid) {
  # init stuff.  can probably axe this down to just above if'n'when user manipulation happens
  $sid = $session->id();
# need to know the "upper" group the user can deal with;  may as well
# stick this in the session rather than calling out to the DB every time.
  $session->param('logingroupid',1);
  $session->param('workinggroupid',1);	# yes, we *do* need to track this too.  er, probably.
}

# handle login redirect
if ($webvar{action} && $webvar{action} eq 'login') {
  # handle user check
  my $newurl = "http://$ENV{HTTP_HOST}$ENV{REQUEST_URI}?sid=$sid&page=domlist";
  print "Status: 302\nLocation: $newurl\n\n";
  exit;
}

my $header = HTML::Template->new(filename => "$templatedir/header.tmpl");
my $footer = HTML::Template->new(filename => "$templatedir/footer.tmpl");

print "Content-type: text/html\n\n", $header->output;

# default
my $perpage = 15;
my $offset = ($webvar{offset} ? $webvar{offset} : 0);

# NB:  these must match the field name and SQL ascend/descend syntax respectively
my $sortfield = "domains";
my $sortorder = "asc";

my ($dbh,$msg) = connectDB("dnsdb","dnsdb","secret");
#my $dbh = DBI->connect("DBI:mysql:database=vegadns","vegadns","secret",
#	{ AutoCommit => 0 }) or die $DBI::errstr;

##fixme.  PLEASE!  <G>
print $msg if !$dbh;

# fiddle hardcoded "defaults" as per system/user (?) prefs
initGlobals($dbh);

# Default page is a login page
my $page;	# to be initialized as an HTML::Template entity sooner or later

# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "$templatedir/login.tmpl");
} else {
  $page = HTML::Template->new(filename => "$templatedir/$webvar{page}.tmpl");
}

$page->param(sid => $sid);

if ($webvar{page} eq 'domlist' or $webvar{page} eq 'index') {
  my $sth = $dbh->prepare("select count(*) from domains");
  $sth->execute;
  my ($count) = ($sth->fetchrow_array);

  if ($count > $perpage) {
    # if there are more results than the default, always show the "all" link
    $page->param(navall => 1);

    if ($offset > 0) {
      $page->param(navfirst => 1);
      $page->param(navprev => 1);
      $page->param(prevoffs => $offset-1);
    }

    # show "next" and "last" links if we're not on the last page of results
    if ( (($offset+1) * $perpage - $count) < 0 ) {
      $page->param(navnext => 1);
      $page->param(nextoffs => $offset+1);
      $page->param(navlast => 1);
      $page->param(lastoffs => int $count/$perpage);
    }
  }

  $page->param(ndomains => $count);

  my @domlist;
  $sth = $dbh->prepare("select domain_id,domain,status,groups.name from domains".
	" inner join groups on domains.group_id=groups.group_id".
	" order by domain limit $perpage offset ".$offset*$perpage);
  $sth->execute;
  my $rownum = 0;
  while (my @data = $sth->fetchrow_array) {
    my %row;
    $row{domainid} = $data[0];
    $row{domain} = $data[1];
    $row{status} = $data[2];
    $row{group} = $data[3];
    $row{bg} = ($rownum++)%2;
    $row{mkactive} = ($data[2] eq 'inactive' ? 1 : 0);
    $row{sid} = $sid;
##fixme:  need to clean up status indicator/usage/inversion
    push @domlist, \%row;
  }
  $page->param(domtable => \@domlist);

} elsif ($webvar{page} eq 'reclist') {

#} elsif ($webvar{page} eq 'domdetail') {

  $page->param(defrec => $webvar{defrec});

##fixme
  $page->param(domain => domainName($dbh,$webvar{id}));
  $page->param(grpid => 1);
##fixme

  if ($webvar{defrec} eq 'y') {
    $page->param(id => $webvar{grpid});	##fixme, hack! hack!
    showdomain('y',1);
  } else {
    $page->param(id => $webvar{id});
    showdomain('n',$webvar{id});
  }

} elsif ($webvar{page} eq 'defrecs') {

  showdomain('def',1);
  $page->param(defrec => 'y');

  my $sth = $dbh->prepare("select * from default_records");
  $sth->execute;
print "<pre>\n";
  while (my @data = $sth->fetchrow_array) {
    foreach (@data) { print; print "\t" };
    print "\n";
  }
print "</pre>\n";

} elsif ($webvar{page} eq 'newdomain') {
  # weesa gonna discard parent_group_id for now
  my $sth = $dbh->prepare("select group_id,parent_group_id,name from groups order by group_id");
  $sth->execute;
  my @grplist;
  while (my ($grpid,$pargrp,$grpname) = $sth->fetchrow_array()) {
    my %row;
    $row{grpname} = $grpname;
    $row{grpval} = $grpid;
##fixme: need magic
#    $row{defgrp} = '';
    push @grplist, \%row;
  }

  $page->param(grplist => \@grplist);

} elsif ($webvar{page} eq 'newrec') {
  print "whee!\n";

newrec();

} elsif ($webvar{page} eq 'addrec') {
  print "wanna add<br>DEBUG: $webvar{parentid}<br>\n";

  my @recargs = ($dbh,$webvar{defrec},$webvar{parentid},$webvar{name},$webvar{type},$webvar{address},$webvar{ttl});
  if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV}) {
    push @recargs, $webvar{distance};
    if ($webvar{type} == $reverse_typemap{SRV}) {
      push @recargs, $webvar{weight};
      push @recargs, $webvar{port};
    }
  }
  push @recargs, 
  my ($code,$msg) = addRec(@recargs);

  if ($code eq 'OK') {
    showdomain($webvar{defrec},$webvar{parentid});
# NB: should **really** redirect here, in case of reload.  >_<  eyowch.
  } else {
    $page->param(add_failed => 1);
    $page->param(errmsg => $msg);
    newrec();	# populate the form... er, mostly.
    $page->param(name => $webvar{name});
    $page->param(address => $webvar{address});
    $page->param(distance => $webvar{distance})
	if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV});
    $page->param(weight => $webvar{weight}) if $webvar{type} == $reverse_typemap{SRV};
    $page->param(port => $webvar{port}) if $webvar{type} == $reverse_typemap{SRV};
  }

} elsif ($webvar{page} eq 'conf_del') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});

  my @tmp = getrecdata($dbh,$webvar{id},$webvar{defrec});

  
} elsif ($webvar{page} eq 'delrec') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
  } else {
#    $page->param(
  }
##work

} elsif ($webvar{page} eq 'editsoa') {

  fillsoa($webvar{defrec},$webvar{recid});

} elsif ($webvar{page} eq 'updatesoa') {
  print "ooooo!\n";

  my $sth;
  my $sql = '';
  # no domain ID, so we're editing the default SOA for a group (we don't care which one here)
  # plus a bit of magic to update the appropriate table
  $sql = "update ".($webvar{domainid} eq '' ? "default_records" : "records").
	" set host='$webvar{prins}:$webvar{contact}',".
	" val='$webvar{refresh}:$webvar{retry}:$webvar{expire}:$webvar{minttl}',".
	" ttl=$webvar{ttl} where record_id=$webvar{recid}";
  $sth = $dbh->prepare($sql);
  $sth->execute;
print "DEBUG: $sql<br>\n";
#print "DEBUG: ".$DBI::errstr;

  if ($sth->err) {
    $page->param(update_failed => 1);
    $page->param(msg => $DBI::errstr);
    fillsoa($webvar{defrec},1);
  } else {
    $page->param(update_failed => 0);
##fixme!  need to set group ID properly here
    showdomain('y',1);
  }

} elsif ($webvar{page} eq 'adddomain') {
  # Need some magic here.

##fixme:  Group should be variable
  my ($code,$msg) = addDomain($dbh,$webvar{domain},1,($webvar{makeactive} eq 'on' ? 1 : 0));

# hokay, a bit of magic to decide which page we hit.
  if ($code eq 'OK') {
    $page = HTML::Template->new(filename => "$templatedir/domlist.tmpl");
  } else {
# oooh, yeah, this is supposed to be a redirect.  er, maybe.  whee.
    $page = HTML::Template->new(filename => "$templatedir/newdomain.tmpl");
    $page->param(add_failed => 1);
    $page->param(domain => $webvar{domain});
    $page->param(errmsg => $msg);
  }

#  my $sth = $dbh->prepare("insert into domains (domain,group_id,status) values (?,?,?)");
#  $sth->execute($webvar{domain},1,($webvar{makeactive} ? 'active' : 'inactive')) or die $DBI::errstr;
#  $sth = $dbh->prepare("select domain_id from domains where domain='$webvar{domain}'");
#  $sth->execute;
#  my ($dom_id) = $sth->fetchrow_array();
#  $sth = $dbh->prepare("select host,type,val,distance,ttl from default_records where group_id=1");
#  my $sth_in = $dbh->prepare("insert into records (domain_id,host,type,val,distance,ttl)".
#	" values ($dom_id,?,?,?,?,?)");
#  $sth->execute;
#  while (my ($host,$type,$val,$dist,$ttl) = $sth->fetchrow_array()) {
#    $host =~ s/DOMAIN/$webvar{domain}/g;
#    $sth_in->execute($host,$type,$val,$dist,$ttl);
#  }
#  $dbh->commit or print "failed to add $webvar{domain}: ".$DBI::errstr."\n";

#  $page->param(add_failed => 1);
}


# spit it out
print $page->output;

print "<div id=debug>webvar keys: <pre>\n";
foreach my $key (keys %webvar) {
  print "key: $key\tval: $webvar{$key}\n";
}
print "</pre>\nENV:\n<pre>\n";
foreach my $key (keys %ENV) {
  print "key: $key\tval: $ENV{$key}\n";
}
print "</pre></div>\n";

print $footer->output;


exit 0;


sub fillsoa {
  my $def = shift;
  my $id = shift;
  my $domname;

  if ($webvar{domain} == 0) {
    $domname = "DOMAIN";
  } else {
    my $sth = $dbh->prepare("select domain from domains where domain_id=$webvar{domain}");
    $sth->execute();
    ($domname) = $sth->fetchrow_array();
  }

  $page->param(domain => $domname);
  $page->param(defrec => !$webvar{domain});
  $page->param(group => $DNSDB::group);

# defaults
  $page->param(defcontact => $DNSDB::def{contact});
  $page->param(defns => $DNSDB::def{prins});
  $page->param(defsoattl => $DNSDB::def{soattl});
  $page->param(defrefresh => $DNSDB::def{refresh});
  $page->param(defretry => $DNSDB::def{retry});
  $page->param(defexpire => $DNSDB::def{expire});
  $page->param(defminttl => $DNSDB::def{minttl});

  # there are probably better ways to do this.  TMTOWTDI.
  my %soa = getSOA($dbh,$def,$id);

  $page->param(domainid	=> $webvar{domain});
  $page->param(recid	=> $soa{recid});
  $page->param(prins	=> ($soa{prins} ? $soa{prins} : $DNSDB::def{prins}));
  $page->param(contact	=> ($soa{contact} ? $soa{contact} : $DNSDB::def{contact}));
  $page->param(refresh	=> ($soa{refresh} ? $soa{refresh} : $DNSDB::def{refresh}));
  $page->param(retry	=> ($soa{retry} ? $soa{retry} : $DNSDB::def{retry}));
  $page->param(expire	=> ($soa{expire} ? $soa{expire} : $DNSDB::def{expire}));
  $page->param(minttl	=> ($soa{minttl} ? $soa{minttl} : $DNSDB::def{minttl}));
  $page->param(ttl	=> ($soa{ttl} ? $soa{ttl} : $DNSDB::def{soattl}));
}

sub showdomain {
  my $def = shift;
  my $id = shift;

  # get the SOA first
  my %soa = getSOA($dbh,$def,$id);

  $page->param(recid	=> $soa{recid});
  $page->param(contact	=> $soa{contact});
  $page->param(prins	=> $soa{prins});
  $page->param(refresh	=> $soa{refresh});
  $page->param(retry	=> $soa{retry});
  $page->param(expire	=> $soa{expire});
  $page->param(minttl	=> $soa{minttl});
  $page->param(ttl	=> $soa{ttl});

#  my @foo2 = getDomRecs($dbh,'def',1);
  my $foo2 = getDomRecs($dbh,$def,$id);

  my $row = 0;
  foreach my $rec (@$foo2) {
    $rec->{type} = $typemap{$rec->{type}};
    $rec->{row} = $row % 2;
    # Feh.
    $rec->{defrec} = $webvar{defrec};
    # And **FEH!!**
    $rec->{sid} = $webvar{sid};
    $row++;
  }
  $page->param(reclist => $foo2);
}

sub newrec {
  my $sth = $dbh->prepare("select val,name from rectypes where stdflag=1 order by listorder");
  $sth->execute;

  my @typelist;
  while (my ($rval,$rname) = $sth->fetchrow_array()) {
    my %row = ( recval => $rval, recname => $rname );
    $row{tselect} = 1 if $rval == $webvar{type};
    push @typelist, \%row;
  }
  $page->param(typelist	=> \@typelist);
  $page->param(domain	=> domainName($dbh,$webvar{domainid}));
  $page->param(parentid	=> $webvar{parentid});
  $page->param(defrec	=> $webvar{defrec});
  $page->param(ttl	=> ($webvar{ttl} ? $webvar{ttl} : $DNSDB::def{minttl}));
}
