#!/usr/bin/perl -w -T
# dns/cgi-bin/dns.cgi
###
# SVN revision info
# $Date: 2009-11-13 23:05:34 +0000 (Fri, 13 Nov 2009) $
# SVN revision $Rev: 35 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2008,2009 - Kris Deugau <kdeugau@deepnet.cx>

use strict;
use warnings;

use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use CGI::Session;
use Crypt::PasswdMD5;
use Net::DNS;
use DBI;

use lib '.';
# custom modules
use DNSDB qw(:ALL);

my @debugbits;  # temp, to be spit out near the end of processing

# Let's do these templates right...
my $templatedir = "templates";
my $sessiondir = "session";

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
my %webvar = $q->Vars;

# persistent stuff needed on most/all pages
my $sid = ($webvar{sid} ? $webvar{sid} : undef);
my $session = new CGI::Session("driver:File", $sid, {Directory => $sessiondir});
#$sid = $session->id() if !$sid;
if (!$sid) {
  # init stuff.  can probably axe this down to just above if'n'when user manipulation happens
  $sid = $session->id();
# need to know the "upper" group the user can deal with;  may as well
# stick this in the session rather than calling out to the DB every time.
  $session->param('logingroup',1);
  $session->param('curgroup',1);	# yes, we *do* need to track this too.  er, probably.
}

my $logingroup = ($session->param('logingroup') ? $session->param('logingroup') : 1);
my $curgroup = ($session->param('curgroup') ? $session->param('curgroup') : $logingroup);
my $group = ($webvar{group} ? $webvar{group} : 1);

# nrgh, can't handle login here because we don't have a database handle to check the user/pass with yet

if ($webvar{action} && $webvar{action} eq 'chgroup') {
  # fiddle session-stored group data
  # magic incantation to... uhhh...
  $session->param('curgroup', $webvar{group});
  $curgroup = ($webvar{group} ? $webvar{group} : $session->param('curgroup'));
}

my $header = HTML::Template->new(filename => "$templatedir/header.tmpl");
my $footer = HTML::Template->new(filename => "$templatedir/footer.tmpl");

# default
#my $perpage = 15;
my $perpage = 3;
my $offset = ($webvar{offset} ? $webvar{offset} : 0);

# NB:  these must match the field name and SQL ascend/descend syntax respectively
my $sortfield = "domains";
my $sortorder = "asc";

my ($dbh,$msg) = connectDB("dnsdb","dnsdb","secret","dbhost");
#my $dbh = DBI->connect("DBI:mysql:database=vegadns","vegadns","secret",
#	{ AutoCommit => 0 }) or die $DBI::errstr;

##fixme.  PLEASE!  <G>
print $msg if !$dbh;

# fiddle hardcoded "defaults" as per system/user (?) prefs
initGlobals($dbh);

# handle login redirect
if ($webvar{action}) {
  if ($webvar{action} eq 'login') {
    my $sth = $dbh->prepare("SELECT user_id,group_id,password,firstname,lastname FROM users WHERE username=?");
    $sth->execute($webvar{username});
    my ($uid,$gid,$pass,$fname,$lname) = $sth->fetchrow_array;
    $webvar{loginfailed} = 1 if !defined($uid);

    if ($pass =~ m|^\$1\$([A-Za-z0-9/.]+)\$|) {
      $webvar{loginfailed} = 1 if $pass ne unix_md5_crypt($webvar{password},$1);
    } else {
      $webvar{loginfailed} = 1 if $pass ne $webvar{password};
    }

    # set session bits
    $session->param('logingroup',$gid);
    $session->param('curgroup',$gid);
    $session->param('username',$webvar{username});

    changepage(page => "domlist") if !defined($webvar{loginfailed});
  } elsif ($webvar{action} eq 'logout') {
    # delete the session
    $session->delete();
    $session->flush();

    my $newurl = "http://$ENV{HTTP_HOST}$ENV{SCRIPT_NAME}";
    $newurl =~ s|/[^/]+$|/|;
    print "Status: 302\nLocation: $newurl\n\n";
    exit;

  }
}

## Default page is a login page
#my $page;	# to be initialized as an HTML::Template entity sooner or later



# decide which page to spit out...
$webvar{page} = 'login' if !$webvar{page};
#if (!$webvar{page}) {
#  $page = HTML::Template->new(filename => "$templatedir/login.tmpl");
#} else {
#}

my $page = HTML::Template->new(filename => "$templatedir/$webvar{page}.tmpl");

$page->param(sid => $sid);

if ($webvar{page} eq 'login') {

  $page->param(loginfailed => 1) if $webvar{loginfailed};
##fixme:  set up session init to actually *check* for session timeout
  $page->param(timeout => 1) if $webvar{sesstimeout};

} elsif ($webvar{page} eq 'domlist' or $webvar{page} eq 'index') {

# hmm.  seeing problems in some possibly-not-so-corner cases.
# this currently only handles "domain on", "domain off"
  if (defined($webvar{action})) {
    domStatus($dbh,$webvar{id},$webvar{action});
  }

  $page->param(curpage => $webvar{page});

  listdomains();

} elsif ($webvar{page} eq 'reclist') {

  # Handle record list for both default records (per-group) and live domain records

  $page->param(defrec => $webvar{defrec});
  $page->param(id => $webvar{id});
  $page->param(curpage => $webvar{page});

# select count(*) from (default_)?records where (group|domain)_id=?
    my $sth = $dbh->prepare("SELECT count(*) FROM ".
	($webvar{defrec} eq 'y' ? 'default_' : '')."records ".
	"WHERE ".($webvar{defrec} eq 'y' ? 'group' : 'domain')."_id=? ".
	"AND NOT type=$reverse_typemap{SOA}");
    $sth->execute($webvar{id});
    my ($count) = ($sth->fetchrow_array);

# fill the page-count and first-previous-next-last-all details
  fill_pgcount($count,"records",domainName($dbh,$webvar{id}));
  fill_fpnla($count);  # should put some params on this sub...

  $page->param(defrec => $webvar{defrec});
  if ($webvar{defrec} eq 'y') {
##fixme: hardcoded group
    showdomain('y',$curgroup);
  } else {
    showdomain('n',$webvar{id});
  }

} elsif ($webvar{page} eq 'newdomain') {


} elsif ($webvar{page} eq 'deldom') {

  $page->param(id => $webvar{id});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
    $page->param(domain => domainName($dbh,$webvar{id}));
# print some neato things?

#  } else {
#    #whether actually deleting or cancelling we redirect to the domain list, default format

  } elsif ($webvar{del} eq 'ok') {
    my ($code,$msg) = delDomain($dbh, $webvar{id});
    if ($code ne 'OK') {
# need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
      listdomains($curgroup);
    } else {
      # success.  go back to the domain list, do not pass "GO"
      changepage(page => "domlist");
    }
  } else {
    # cancelled.  whee!
    changepage(page => "domlist");
  }

} elsif ($webvar{page} eq 'record') {

  if ($webvar{recact} eq 'new') {

    $page->param(todo => "Add record to");
    $page->param(recact => "add");
    fill_rectypes();

  } elsif ($webvar{recact} eq 'add') {

    my @recargs = ($dbh,$webvar{defrec},$webvar{parentid},$webvar{name},$webvar{type},$webvar{address},$webvar{ttl});
    if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV}) {
      push @recargs, $webvar{distance};
      if ($webvar{type} == $reverse_typemap{SRV}) {
        push @recargs, $webvar{weight};
        push @recargs, $webvar{port};
      }
    }
    my ($code,$msg) = addRec(@recargs);

    if ($code eq 'OK') {
      changepage(page => "reclist", id => $webvar{parentid}, defrec => $webvar{defrec});
    } else {

      $page->param(failed	=> 1);
      $page->param(errmsg	=> $msg);
      $page->param(wastrying	=> "adding");
      $page->param(todo		=> "Add record to");
      $page->param(recact	=> "add");
      $page->param(parentid	=> $webvar{parentid});
      $page->param(defrec	=> $webvar{defrec});
      $page->param(id		=> $webvar{id});
      fill_recdata();	# populate the form... er, mostly.
    }

  } elsif ($webvar{recact} eq 'edit') {

    $page->param(todo		=> "Update record");
    $page->param(recact		=> "update");
    $page->param(parentid	=> $webvar{parentid});
    $page->param(id		=> $webvar{id});
    $page->param(defrec		=> $webvar{defrec});
    my $sth = $dbh->prepare("SELECT host,type,val,distance,weight,port,ttl FROM ".
	($webvar{defrec} eq 'y' ? 'default_' : '')."records WHERE record_id=?");
    $sth->execute($webvar{id});
    my ($host,$type,$val,$distance,$weight,$port,$ttl) = $sth->fetchrow_array;
    $page->param(name		=> $host);
    $page->param(address	=> $val);
    $page->param(distance	=> $distance);
    $page->param(weight		=> $weight);
    $page->param(port		=> $port);
    $page->param(ttl		=> $ttl);
    fill_rectypes($type);

  } elsif ($webvar{recact} eq 'update') {

    my ($code,$msg) = updateRec($dbh,$webvar{defrec},$webvar{id},
	$webvar{name},$webvar{type},$webvar{address},$webvar{ttl},
	$webvar{distance},$webvar{weight},$webvar{port});

    if ($code eq 'OK') {
      changepage(page => "reclist", id => $webvar{parentid}, defrec => $webvar{defrec});
    } else {
      $page->param(failed	=> 1);
      $page->param(errmsg	=> $msg);
      $page->param(wastrying	=> "updating");
      $page->param(todo		=> "Update record");
      $page->param(recact	=> "update");
      $page->param(parentid	=> $webvar{parentid});
      $page->param(defrec	=> $webvar{defrec});
      $page->param(id		=> $webvar{id});
      fill_recdata();
    }
  }

  if ($webvar{defrec} eq 'y') {
    $page->param(dohere => "default records in group ".groupName($dbh,$webvar{parentid}));
  } else {
    $page->param(parentid => $webvar{parentid});
#    $page->param(id => $webvar{id});
    $page->param(dohere => domainName($dbh,$webvar{parentid}));
  }

} elsif ($webvar{page} eq 'newrec') {
  push @debugbits, "whee!\n";

  # populate most fields as needed.  (eg, type list.)
  stdrecs();

} elsif ($webvar{page} eq 'addrec') {

  my @recargs = ($dbh,$webvar{defrec},$webvar{parentid},$webvar{name},$webvar{type},$webvar{address},$webvar{ttl});
  if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV}) {
    push @recargs, $webvar{distance};
    if ($webvar{type} == $reverse_typemap{SRV}) {
      push @recargs, $webvar{weight};
      push @recargs, $webvar{port};
    }
  }
# wtf?
#  push @recargs, 
  my ($code,$msg) = addRec(@recargs);

  if ($code eq 'OK') {
    showdomain($webvar{defrec},$webvar{parentid});
# NB: should **really** redirect here, in case of reload.  >_<  eyowch.
  } else {
    $page->param(add_failed => 1);
    $page->param(errmsg => $msg);
    stdrecs($webvar{type});	# populate the form... er, mostly.
    $page->param(name => $webvar{name});
    $page->param(address => $webvar{address});
    $page->param(distance => $webvar{distance})
	if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV});
    $page->param(weight => $webvar{weight}) if $webvar{type} == $reverse_typemap{SRV};
    $page->param(port => $webvar{port}) if $webvar{type} == $reverse_typemap{SRV};
  }

  $page->param(defrec => $webvar{defrec});

} elsif ($webvar{page} eq 'conf_del') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});

  my @tmp = getrecdata($dbh,$webvar{id},$webvar{defrec});

} elsif ($webvar{page} eq 'delrec') {

  $page->param(id => $webvar{id});
  $page->param(defrec => $webvar{defrec});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
    my %rec = getRecLine($dbh,$webvar{defrec},$webvar{id});
    $page->param(host => $rec{host});
    $page->param(ftype => $typemap{$rec{type}});
    $page->param(recval => $rec{val});
  } else {
    my ($code,$msg) = delRec($dbh,$webvar{defrec},$webvar{id});
    if ($code ne 'OK') {
## need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
    }
##fixme:  group/parent instead of hardcoded 1
    showdomain('y',1);
  }

} elsif ($webvar{page} eq 'editsoa') {

  fillsoa($webvar{defrec},$webvar{recid});

} elsif ($webvar{page} eq 'updatesoa') {
  print "ooooo!\n";

  my $sth;
  my $sql = '';
  # no domain ID, so we're editing the default SOA for a group (we don't care which one here)
  # plus a bit of magic to update the appropriate table
  $sql = "update ".($webvar{domainid} eq '' ? "default_records" : "records").
	" set host='$webvar{prins}:$webvar{contact}',".
	" val='$webvar{refresh}:$webvar{retry}:$webvar{expire}:$webvar{minttl}',".
	" ttl=$webvar{ttl} where record_id=$webvar{recid}";
  $sth = $dbh->prepare($sql);
  $sth->execute;

  if ($sth->err) {
    $page->param(update_failed => 1);
    $page->param(msg => $DBI::errstr);
    fillsoa($webvar{defrec},1);
  } else {
    $page->param(update_failed => 0);
##fixme!  need to set group ID properly here
    showdomain('y',1);
  }

} elsif ($webvar{page} eq 'adddomain') {
  # Need some magic here.

##fixme:  Group should be variable
  my ($code,$msg) = addDomain($dbh,$webvar{domain},$webvar{group},($webvar{makeactive} eq 'on' ? 1 : 0));

# hokay, a bit of magic to decide which page we hit.
  if ($code eq 'OK') {
# redirect to dns.cgi?etc&page=reclist
    changepage(page => "reclist", id => $msg);
#    $page = HTML::Template->new(filename => "$templatedir/reclist.tmpl");
#    showdomain(0,$msg);
  } else {
# oooh, yeah, this is supposed to be a redirect.  er, maybe.  whee.
##fixme: session ID
    $page = HTML::Template->new(filename => "$templatedir/newdomain.tmpl");
    $page->param(add_failed => 1);
    $page->param(domain => $webvar{domain});
    $page->param(errmsg => $msg);
  }

} elsif ($webvar{page} eq 'grpman') {

  listgroups();
  $page->param(curpage => $webvar{page});

} elsif ($webvar{page} eq 'newgrp') {

  # do.. uhh.. stuff.. if we have no webvar{action}
  if ($webvar{action} && $webvar{action} eq 'add') {
	# not gonna provide the 4th param: template-or-clone flag, just yet
    my ($code,$msg) = addGroup($dbh, $webvar{newgroup}, $webvar{pargroup});
    changepage(page => "grpman") if $code eq 'OK';
    $page->param(add_failed => 1);
    $page->param(errmsg => $msg);
    $page->param(newgroup => $webvar{newgroup});
     fill_grouplist('pargroup',$webvar{pargroup});
  } else {
#    $page->param
     fill_grouplist('pargroup',$curgroup);

  }

} elsif ($webvar{page} eq 'delgrp') {

  $page->param(id => $webvar{id});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
#    $page->param(groupname => groupName($dbh,$webvar{id}));
# print some neato things?

#  } else {
#    #whether actually deleting or cancelling we redirect to the group list, default format

  } elsif ($webvar{del} eq 'ok') {
    my ($code,$msg) = delGroup($dbh, $webvar{id});
push @debugbits, groupName($dbh, $webvar{id});
    if ($code ne 'OK') {
# need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
      $page->param(curpage => $webvar{page});
      listgroups();
    } else {
      # success.  go back to the domain list, do not pass "GO"
      changepage(page => "grpman");
    }
  } else {
    # cancelled.  whee!
    changepage(page => "grpman");
  }
  $page->param(delgroupname => groupName($dbh, $webvar{id}));

} elsif ($webvar{page} eq 'useradmin') {

  list_users();
  $page->param(curpage => $webvar{page});

} elsif ($webvar{page} eq 'newuser') {

  # foo?
  fill_actypelist();

} elsif ($webvar{page} eq 'adduser') {

  my ($code,$msg);
  
  if ($webvar{pass1} ne $webvar{pass2}) {
    $code = 'FAIL';
    $msg = "Passwords don't match";
  } else {
    ($code,$msg) = addUser($dbh,$webvar{username}, $webvar{group}, $webvar{pass1},
	($webvar{makeactive} eq 'on' ? 1 : 0), $webvar{accttype}, 
	$webvar{fname}, $webvar{lname}, $webvar{phone});
  }

# hokay, a bit of magic to decide which page we hit.
  if ($code eq 'OK') {
    changepage(page => "useradmin");
  } else {
# oooh, yeah, this is supposed to be a redirect.  er, maybe.  whee.
#    $page = HTML::Template->new(filename => "$templatedir/newuser.tmpl");
    $page->param(add_failed => 1);
    $page->param(username => $webvar{username});
    $page->param(fname => $webvar{fname});
    $page->param(lname => $webvar{lname});
    $page->param(pass1 => $webvar{pass1});
    $page->param(pass2 => $webvar{pass2});
    $page->param(errmsg => $msg);
    fill_actypelist();
  }

  $page->param(add_failed => 1);

} elsif ($webvar{page} eq 'deluser') {

  $page->param(id => $webvar{id});
  # first pass = confirm y/n (sorta)
  if (!defined($webvar{del})) {
    $page->param(del_getconf => 1);
    $page->param(user => userFullName($dbh,$webvar{id}));
  } elsif ($webvar{del} eq 'ok') {
    my ($code,$msg) = delUser($dbh, $webvar{id});
    if ($code ne 'OK') {
# need to find failure mode
      $page->param(del_failed => 1);
      $page->param(errmsg => $msg);
      list_users($curgroup);
    } else {
      # success.  go back to the domain list, do not pass "GO"
      changepage(page => "useradmin");
    }
  } else {
    # cancelled.  whee!
    changepage(page => "useradmin");
  }

} elsif ($webvar{page} eq 'dnsq') {

  $page->param(qfor => $webvar{qfor}) if $webvar{qfor};
  fill_rectypes($webvar{type} ? $webvar{type} : '', 1);
  $page->param(nrecurse => $webvar{nrecurse}) if $webvar{nrecurse};
  $page->param(resolver => $webvar{resolver}) if $webvar{resolver};

  if ($webvar{qfor}) {
    my $resolv = Net::DNS::Resolver->new;
    $resolv->tcp_timeout(5);	# make me adjustable!
    $resolv->udp_timeout(5);	# make me adjustable!
    $resolv->recurse(0) if $webvar{nrecurse};
    $resolv->nameservers($webvar{resolver}) if $webvar{resolver};
    my $query = $resolv->query($webvar{qfor}, $typemap{$webvar{type}});
    if ($query) {

      $page->param(showresults => 1);

      my @answer;
      foreach my $rr ($query->answer) {
#	next unless $rr->type eq "A" or $rr->type eq 'NS';
	my %row;
	my ($host,$ttl,$class,$type,$data) =
		($rr->string =~ /^([0-9a-zA-Z_.-]+)\s+(\d+)\s+([A-Za-z]+)\s+([A-Za-z]+)\s+(.+)$/s);
	$row{host} = $host;
	$row{ftype} = $type;
	$row{rdata} = ($type eq 'SOA' ? "<pre>$data</pre>" : $data);
        push @answer, \%row;
      }
      $page->param(answer => \@answer);

      my @additional;
      foreach my $rr ($query->additional) {
#	next unless $rr->type eq "A" or $rr->type eq 'NS';
	my %row;
	my ($host,$ttl,$class,$type,$data) =
		($rr->string =~ /^([0-9a-zA-Z_.-]+)\s+(\d+)\s+([A-Za-z]+)\s+([A-Za-z]+)\s+(.+)$/);
	$row{host} = $host;
	$row{ftype} = $type;
	$row{rdata} = $data;
        push @additional, \%row;
      }
      $page->param(additional => \@additional);

      my @authority;
      foreach my $rr ($query->authority) {
#	next unless $rr->type eq "A" or $rr->type eq 'NS';
	my %row;
	my ($host,$ttl,$class,$type,$data) =
		($rr->string =~ /^([0-9a-zA-Z_.-]+)\s+(\d+)\s+([A-Za-z]+)\s+([A-Za-z]+)\s+(.+)$/);
	$row{host} = $host;
	$row{ftype} = $type;
	$row{rdata} = $data;
        push @authority, \%row;
      }
      $page->param(authority => \@authority);

      $page->param(usedresolver => $resolv->answerfrom);
      $page->param(frtype => $typemap{$webvar{type}});

    } else {
      $page->param(errmsg => $resolv->errorstring);
    }
  }
  ## done DNS query

} elsif ($webvar{page} eq 'axfr') {

  # don't need this while we've got the dropdown in the menu.  hmm.
  #fill_grouplist;

  $page->param(ifrom => $webvar{ifrom}) if $webvar{ifrom};
  $page->param(rwsoa => $webvar{rwsoa}) if $webvar{rwsoa};
  $page->param(rwns => $webvar{rwns}) if $webvar{rwns};
  $page->param(dominactive => 1) if !$webvar{domactive};
  $page->param(importdoms => $webvar{importdoms}) if $webvar{importdoms};
##work

##fixme: check group too?
  if ($webvar{doit} eq 'y' && !$webvar{ifrom}) {
    $page->param(errmsg => "Need to set host to import from");
  } elsif ($webvar{doit} eq 'y' && !$webvar{importdoms}) {
    $page->param(errmsg => "Need domains to import");
  } else {
    my @domlist = split /\s+/, $webvar{importdoms};
    my @results;
my $rnum = 0;
    foreach my $domain (@domlist) {
      my %row;
      my ($code,$msg) = importAXFR($dbh, $webvar{ifrom}, $domain, $webvar{group},
	$webvar{domstatus}, $webvar{rwsoa}, $webvar{rwns});
      $row{domok} = $msg if $code eq 'OK';
      if ($code eq 'WARN') {
	$msg =~ s|\n|<br />|g;
	$row{domwarn} = $msg;
      }
      $row{domerr} = $msg if $code eq 'FAIL';
      # do stuff!  DNSDB::importAXFR($webvar{ifrom}, $webvar{rwsoa}, $webvar{rwns}, $domain, <flags>)
      $row{domain} = $domain;
#      $row{row} = $rnum++;
      push @results, \%row;
    }
    $page->param(axfrresults => \@results);
  }

}


# start output here so we can redirect pages.
print "Content-type: text/html\n\n", $header->output;

##common bits
if ($webvar{page} ne 'login') {
  $page->param(username => $session->param("username"));

  $page->param(group => $curgroup);
  $page->param(groupname => groupName($dbh,$curgroup));

  # group tree.  should go elsewhere, probably
  my $tmpgrplist = fill_grptree($logingroup,$curgroup);
  $page->param(grptree => $tmpgrplist);

  # stuff for menu group change.  nb: this is icky.
  fill_grouplist("grouplist");
  $page->param(whereami => $ENV{REQUEST_URI});
}

foreach (@debugbits) { print; }

# spit it out
print $page->output;

print "<div id=debug>webvar keys: <pre>\n";
foreach my $key (keys %webvar) {
  print "key: $key\tval: $webvar{$key}\n";
}
print "</pre>\nsession:\n<pre>\n";
my $sesdata = $session->dataref();
foreach my $key (keys %$sesdata) {
  print "key: $key\tval: ".$sesdata->{$key}."\n";
}
print "</pre>\nENV:\n<pre>\n";
foreach my $key (keys %ENV) {
  print "key: $key\tval: $ENV{$key}\n";
}
print "</pre></div>\n";

print $footer->output;

# as per the docs, Just In Case
$session->flush();

exit 0;


sub fill_grptree {
  my $root = shift;
  my $cur = shift;

  my @childlist;

  my $grptree = HTML::Template->new(filename => 'templates/grptree.tmpl');
  getChildren($dbh,$root,\@childlist,'immediate');
  return if $#childlist == -1;
  my @grouplist;
  foreach (@childlist) {
    my %row;
    $row{grpname} = groupName($dbh,$_);
    $row{grpname} = "<b>$row{grpname}</b>" if $_ == $cur;
    $row{subs} = fill_grptree($_,$cur);
    push @grouplist, \%row;
  }
  $grptree->param(treelvl => \@grouplist);
  return $grptree->output;
}


sub changepage {
  my %params = @_;	# think this works the way I want...

  # handle user check
  my $newurl = "http://$ENV{HTTP_HOST}$ENV{SCRIPT_NAME}?sid=$sid";
  foreach (keys %params) {
    $newurl .= "&$_=$params{$_}";
  }

  # Just In Case
  $session->flush();

  print "Status: 302\nLocation: $newurl\n\n";
  exit;
} # end changepage


sub fillsoa {
  my $def = shift;
  my $id = shift;
  my $domname;

  if ($webvar{domain} == 0) {
    $domname = "DOMAIN";
  } else {
    my $sth = $dbh->prepare("SELECT domain FROM domains WHERE domain_id=?");
    $sth->execute($webvar{domain});
    ($domname) = $sth->fetchrow_array();
  }

  $page->param(domain	=> $domname);
  $page->param(defrec	=> !$webvar{domain});
  $page->param(group	=> $DNSDB::group);

# defaults
  $page->param(defcontact	=> $DNSDB::def{contact});
  $page->param(defns		=> $DNSDB::def{prins});
  $page->param(defsoattl	=> $DNSDB::def{soattl});
  $page->param(defrefresh	=> $DNSDB::def{refresh});
  $page->param(defretry		=> $DNSDB::def{retry});
  $page->param(defexpire	=> $DNSDB::def{expire});
  $page->param(defminttl	=> $DNSDB::def{minttl});

  # there are probably better ways to do this.  TMTOWTDI.
  my %soa = getSOA($dbh,$def,$id);

  $page->param(domainid	=> $webvar{domain});
  $page->param(recid	=> $soa{recid});
  $page->param(prins	=> ($soa{prins} ? $soa{prins} : $DNSDB::def{prins}));
  $page->param(contact	=> ($soa{contact} ? $soa{contact} : $DNSDB::def{contact}));
  $page->param(refresh	=> ($soa{refresh} ? $soa{refresh} : $DNSDB::def{refresh}));
  $page->param(retry	=> ($soa{retry} ? $soa{retry} : $DNSDB::def{retry}));
  $page->param(expire	=> ($soa{expire} ? $soa{expire} : $DNSDB::def{expire}));
  $page->param(minttl	=> ($soa{minttl} ? $soa{minttl} : $DNSDB::def{minttl}));
  $page->param(ttl	=> ($soa{ttl} ? $soa{ttl} : $DNSDB::def{soattl}));
}

sub showdomain {
  my $def = shift;
  my $id = shift;

  # get the SOA first
  my %soa = getSOA($dbh,$def,$id);

  $page->param(recid	=> $soa{recid});
  $page->param(contact	=> $soa{contact});
  $page->param(prins	=> $soa{prins});
  $page->param(refresh	=> $soa{refresh});
  $page->param(retry	=> $soa{retry});
  $page->param(expire	=> $soa{expire});
  $page->param(minttl	=> $soa{minttl});
  $page->param(ttl	=> $soa{ttl});

#  my @foo2 = getDomRecs($dbh,'def',1);
  my $foo2 = getDomRecs($dbh,$def,$id,$perpage,$webvar{offset});

  my $row = 0;
  foreach my $rec (@$foo2) {
    $rec->{type} = $typemap{$rec->{type}};
    $rec->{row} = $row % 2;
    $rec->{defrec} = $webvar{defrec};
    $rec->{sid} = $webvar{sid};
    $rec->{id} = $id;
    $rec->{distance} = 'n/a' unless ($rec->{type} eq 'MX' || $rec->{type} eq 'SRV'); 
    $rec->{weight} = 'n/a' unless ($rec->{type} eq 'SRV'); 
    $rec->{port} = 'n/a' unless ($rec->{type} eq 'SRV');
    $row++;
  }
  $page->param(reclist => $foo2);
}


# fill in record type list on add/update/edit record template
sub fill_rectypes {
  my $type = shift || $reverse_typemap{A};
  my $soaflag = shift || 0;

  my $sth = $dbh->prepare("SELECT val,name FROM rectypes WHERE stdflag=1 ORDER BY listorder");
  $sth->execute;
  my @typelist;
  while (my ($rval,$rname) = $sth->fetchrow_array()) {
    my %row = ( recval => $rval, recname => $rname );
    $row{tselect} = 1 if $rval == $type;
    push @typelist, \%row;
  }
  if ($soaflag) {
    my %row = ( recval => $reverse_typemap{SOA}, recname => 'SOA' );
    $row{tselect} = 1 if $reverse_typemap{SOA} == $type;
    push @typelist, \%row;
  }
  $page->param(typelist	=> \@typelist);
} # fill_rectypes

sub fill_recdata {
  fill_rectypes($webvar{type});

  $page->param(name	=> $webvar{name});
  $page->param(address	=> $webvar{address});
  $page->param(distance	=> $webvar{distance})
	if ($webvar{type} == $reverse_typemap{MX} or $webvar{type} == $reverse_typemap{SRV});
  $page->param(weight	=> $webvar{weight}) if $webvar{type} == $reverse_typemap{SRV};
  $page->param(port	=> $webvar{port}) if $webvar{type} == $reverse_typemap{SRV};
  $page->param(ttl	=> ($webvar{ttl} ? $webvar{ttl} : $DNSDB::def{minttl}));
}


sub fill_actypelist {
  my @actypes;

  my %row1 = (actypeval => 'u', actypename => 'user');
  $row1{typesel} = 1 if $webvar{accttype} eq 'u';
  push @actypes, \%row1;

  my %row2 = (actypeval => 'S', actypename => 'superuser');
  $row2{typesel} = 1 if $webvar{accttype} eq 'S';
  push @actypes, \%row2;

  $page->param(actypelist	=> \@actypes);
}


sub fill_fpnla {
  my $count = shift;
##fixme
  if ($offset eq 'all') {
    push @debugbits, "foo!  wanna see'em all\n";
  } else {
    # all these bits only have sensible behaviour if offset is numeric. err, probably.
    if ($count > $perpage) {
      # if there are more results than the default, always show the "all" link
      $page->param(navall => 1);

      if ($offset > 0) {
        $page->param(navfirst => 1);
        $page->param(navprev => 1);
        $page->param(prevoffs => $offset-1);
      }

      # show "next" and "last" links if we're not on the last page of results
      if ( (($offset+1) * $perpage - $count) < 0 ) {
        $page->param(navnext => 1);
        $page->param(nextoffs => $offset+1);
        $page->param(navlast => 1);
        $page->param(lastoffs => int (($count-1)/$perpage));
      }
    }
  }
} # end fill_fpnla()


sub fill_pgcount {
  my $pgcount = shift;
  my $pgtype = shift;
  my $parent = shift;

  $page->param(ntot => $pgcount);
  $page->param(nfirst => (($offset eq 'all' ? 0 : $offset)*$perpage+1));
  $page->param(npglast => ($offset eq 'all' ? $pgcount :
	( (($offset+1)*$perpage) > $pgcount ? $pgcount : (($offset+1)*$perpage) )
	));
  $page->param(pgtype => $pgtype);
  $page->param(parent => $parent);
} # end fill_pgcount()


sub listdomains {
  my $sth = $dbh->prepare("SELECT count(*) FROM domains WHERE group_id=?");
  $sth->execute($curgroup);
  my ($count) = $sth->fetchrow_array;

# fill page count and first-previous-next-last-all bits
##fixme - hardcoded group bit
  fill_pgcount($count,"domains",groupName($dbh,$curgroup));
  fill_fpnla($count);

##fixme - group
  $page->param(group => $curgroup);
  my @domlist;
  $sth = $dbh->prepare("SELECT domain_id,domain,status,groups.group_name FROM domains".
	" INNER JOIN groups ON domains.group_id=groups.group_id".
	" WHERE domains.group_id=?".
	" ORDER BY domain".($offset eq 'all' ? '' : " LIMIT $perpage OFFSET ".$offset*$perpage));
  $sth->execute($curgroup);
  my $rownum = 0;
  while (my @data = $sth->fetchrow_array) {
    my %row;
    $row{domainid} = $data[0];
    $row{domain} = $data[1];
    $row{status} = ($data[2] ? 'Active' : 'Inactive');
    $row{group} = $data[3];
    $row{bg} = ($rownum++)%2;
#    $row{mkactive} = ($data[2] eq 'inactive' ? 1 : 0);
    $row{mkactive} = !$data[2];
    $row{sid} = $sid;
    $row{offset} = $offset;
##fixme:  need to clean up status indicator/usage/inversion
    push @domlist, \%row;
  }
  $page->param(domtable => \@domlist);
} # end listdomains()


sub listgroups {
  my @childgroups;
  getChildren($dbh, $logingroup, \@childgroups, 'all');
  my $childlist = join(',',@childgroups);

  my $sql = "SELECT count(*) FROM groups WHERE group_id IN ($logingroup".($childlist ? ",$childlist" : '').")";
  my $sth = $dbh->prepare($sql);

  $sth->execute;
  my ($count) = ($sth->fetchrow_array);
# fill page count and first-previous-next-last-all bits
##fixme - hardcoded group bit
  fill_pgcount($count,"groups",'');
  fill_fpnla($count);

  my @grouplist;
  $sth = $dbh->prepare("SELECT g.group_id, g.group_name, g2.group_name, ".
	"count(distinct(u.username)), count(distinct(d.domain)) ".
	"FROM groups g ".
	"INNER JOIN groups g2 ON g2.group_id=g.parent_group_id ".
	"LEFT OUTER JOIN users u ON u.group_id=g.group_id ".
	"LEFT OUTER JOIN domains d ON d.group_id=g.group_id ".
	"WHERE g.group_id IN ($logingroup".($childlist ? ",$childlist" : '').") ".
	"GROUP BY g.group_id, g.group_name, g2.group_name ".
	"ORDER BY g.group_id".($offset eq 'all' ? '' : " LIMIT $perpage OFFSET ".$offset*$perpage));
  $sth->execute;

  my $rownum = 0;
  while (my @data = $sth->fetchrow_array) {
    my %row;
    $row{groupid} = $data[0];
    $row{groupname} = $data[1];
    $row{pgroup} = $data[2];
    $row{nusers} = $data[3];
    $row{ndomains} = $data[4];
    $row{bg} = ($rownum++)%2;
    $row{sid} = $sid;
    push @grouplist, \%row;
  }
  $page->param(grouptable => \@grouplist);
} # end listgroups()


sub fill_grouplist {
  my $template_var = shift;
  my $cur = shift || $curgroup;

  my @childgroups;
  getChildren($dbh, $logingroup, \@childgroups, 'all');
  my $childlist = join(',',@childgroups);

  # weesa gonna discard parent_group_id for now
  my $sth = $dbh->prepare("SELECT group_id,parent_group_id,group_name FROM groups ".
	"WHERE group_id IN ($logingroup".($childlist ? ",$childlist" : '').")".
	"ORDER BY group_id");
  $sth->execute;
  my @grouplist;
  while (my ($groupid,$pargroup,$groupname) = $sth->fetchrow_array()) {
    my %row;
    $row{groupname} = $groupname;
    $row{groupval} = $groupid;
##fixme: need magic
#    $row{defgroup} = '';
    $row{groupactive} = 1 if $groupid == $cur;
    push @grouplist, \%row;
  }

  $page->param("$template_var" => \@grouplist);

} # end fill_grouplist()


sub list_users {
  my $sth = $dbh->prepare("select count(*) from users where group_id=?");
  $sth->execute($curgroup);
  my ($count) = ($sth->fetchrow_array);

# fill page count and first-previous-next-last-all bits
##fixme - hardcoded group bit
  fill_pgcount($count,"users",'');
  fill_fpnla($count);

  my @userlist;
  $sth = $dbh->prepare("SELECT u.user_id, u.username, u.firstname, u.lastname, u.type, g.group_name, u.status ".
        "FROM users u ".
        "INNER JOIN groups g ON u.group_id=g.group_id ".
	"WHERE u.group_id=?".
	($offset eq 'all' ? '' : " LIMIT $perpage OFFSET ".$offset*$perpage));
  $sth->execute($curgroup);

  my $rownum = 0;
  while (my @data = $sth->fetchrow_array) {
    my %row;
    $row{userid} = $data[0];
    $row{username} = $data[1];
    $row{userfull} = "$data[2] $data[3]";
    $row{usertype} = ($data[4] eq 'S' ? 'superuser' : "user");
    $row{usergroup} = $data[5];
    $row{mkactive} = $data[6];
    $row{bg} = ($rownum++)%2;
    $row{sid} = $sid;
    push @userlist, \%row;
  }
  $page->param(usertable => \@userlist);
}
