# dns/trunk/DNSDB/ExportBIND.pm
# BIND data export/publication
# Call through DNSDB.pm's export() sub
##
# $Id: ExportBIND.pm 848 2022-09-01 16:43:41Z kdeugau $
# Copyright 2022 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

package DNSDB::ExportBIND;

use strict;
use warnings;

sub export {
  # expected to be a DNSDB object
  my $self = shift;
  my $dbh = $self->{dbh};

  # allow for future exports of subgroups of records
  my $viewlist = $dnsdb->getLocList(curgroup => 1);

  # Write the view list to a configuration fragment
  if ($viewlist) {
    foreach my $view (@{$viewlist}) {
#print Dumper($view);
#      print BINDCONF "view $view->{location} {\n";
      print "view $view->{location} {\n";
      # could also use an acl { ... }; statement, then match-clients { aclname; };, but that gets hairy
      # note that some semantics of data visibility need to be handled by the record export, since it's
      # not 100% clear if the semantics of a tinydns view with an empty IP list (matches anyone) are the
      # same as a BIND view with match-clients { any; };
      if ($view->{iplist}) {
#         print BINDCONF "  match-clients { ".join("; ", $view->iplist)."; };\n";
         print "  match-clients { ".join("; ", split(/[\s,]+/, $view->{iplist}))."; };\n";
      } else {
#         print BINDCONF "  match-clients { any; };\n"
         print "  match-clients { any; };\n"
      }
      print "};\n\n";
    } # foreach @$viewlist
  } # if $viewlist

} # export()

1;
