# dns/trunk/DNSDB/ExportBIND.pm
# BIND data export/publication
# Call through DNSDB.pm's export() sub
##
# $Id: ExportBIND.pm 849 2022-09-01 17:17:46Z kdeugau $
# Copyright 2022 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

package DNSDB::ExportBIND;

use strict;
use warnings;

sub export {
  # expected to be a DNSDB object
  my $self = shift;
  my $dbh = $self->{dbh};

  # to be a hash of views/locations, containing lists of zones
  my %viewzones;

  # allow for future exports of subgroups of records
  my $viewlist = $self->getLocList(curgroup => 1);

  # Fetch active zone list
  my $revsth = $self->{dbh}->prepare("SELECT rdns_id,revnet,status,changed,default_location FROM revzones WHERE status=1 ".
	"ORDER BY masklen(revnet) DESC, rdns_id");
  # Unflag changed zones, so we can maybe cache the export and not redo everything every time
  my $zonesth = $self->{dbh}->prepare("UPDATE revzones SET changed='n' WHERE rdns_id=?");
  $revsth->execute();
  while (my ($revid,$revzone,$revstat,$changed,$defloc) = $revsth->fetchrow_array) {
    # fetch a list of views/locations present in the zone.  we need to publish a file for each one.
    # in the event that no locations are present (~~ $viewlist is empty), /%view collapses to nothing in the zone path
    my (@loclist) = $self->{dbh}->selectrow_array("SELECT DISTINCT location FROM records WHERE rdns_id = ?", undef, $revid);
    push @loclist, $defloc;
    my $zonepath = $self->{bind_export_zone_path};
    my %zonefiles;  # to be a list of file handles.
##fixme:  convert logical revzone into .arpa name
    foreach my $loc (@loclist) {
      local $zonepath =~ s/\%view/$loc/;
print "open $zonefiles{$loc}, $zonepath\n";
    }

  } # revsth->fetch


  # Write the view configuration last, because otherwise we have to be horribly inefficient
  # at figuring out which zones are visible/present in which views
  if ($viewlist) {
    foreach my $view (@{$viewlist}) {
#print Dumper($view);
#      print BINDCONF "view $view->{location} {\n";
      print "view $view->{location} {\n";
      # could also use an acl { ... }; statement, then match-clients { aclname; };, but that gets hairy
      # note that some semantics of data visibility need to be handled by the record export, since it's
      # not 100% clear if the semantics of a tinydns view with an empty IP list (matches anyone) are the
      # same as a BIND view with match-clients { any; };
      if ($view->{iplist}) {
#         print BINDCONF "  match-clients { ".join("; ", $view->iplist)."; };\n";
         print "  match-clients { ".join("; ", split(/[\s,]+/, $view->{iplist}))."; };\n";
      } else {
#         print BINDCONF "  match-clients { any; };\n";
         print "  match-clients { any; };\n";
      }
      foreach my $zone (@{$viewzones{$view->{location}}}) {
##fixme:  notify settings, maybe per-zone?
        print qq(  zone "$zone" IN {\n\ttype master;\n\tnotify no;\n\tfile "db.$zone";\n  };\n);
      }
      print "};\n\n";
    } # foreach @$viewlist
  } # if $viewlist

} # export()

1;
