#!/usr/bin/perl
# Import script for autoaxfr data
##
# $Id: autoaxfr-import.pl 925 2025-08-20 21:32:47Z kdeugau $
# Copyright 2025 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;

use DBI;
use Data::Dumper;

# Taint-safe (ish) voodoo to push "the directory the script is in" into @INC.
use File::Spec ();
use File::Basename ();
my $path;
BEGIN {
    $path = File::Basename::dirname(File::Spec->rel2abs($0));
    if ($path =~ /(.*)/) {
        $path = $1;
    }
}
use lib $path;

use DNSDB;

my $dnsdb = new DNSDB;

usage() if !@ARGV;

sub usage {
  die q(usage: autoaxfr-import.pl /path/to/autoaxfr-root
	/path/to/autoaxfr-root is the directory containing the slaves/
	directory that tells autoaxfr which zones to AXFR from which
	hosts, and the zones/ directory where it leaves the tinydns-formatted
	zone data.

	All zones are imported as there is no sane way to share manually-
	managed zones and dnsadmin-managed zones in one autoaxfr instance.
);
}

##fixme: option flags for these
my $cverbose = 0;
my $group = 1;
my $status = 1;

my $dbh = $dnsdb->{dbh};

# collect some things for logging
($dnsdb->{logusername}, undef, undef, undef, undef, undef, $dnsdb->{logfullname}) = getpwuid($<);
$dnsdb->{logfullname} =~ s/,//g;
$dnsdb->{loguserid} = 0;        # not worth setting up a pseudouser the way the RPC system does
$dnsdb->{logusername} = $dnsdb->{logusername}."/autoaxfr-import.pl";
$dnsdb->{logfullname} = $dnsdb->{logusername} if !$dnsdb->{logfullname};
$dnsdb->{logfullname} = $dnsdb->{logfullname}."/autoaxfr-import.pl";

$dbh->{AutoCommit} = 0;
$dbh->{RaiseError} = 1;

eval {

  my $logparent = $dnsdb->_log(group_id => $group,
	entry => "[ Importing secondary zones from autoaxfr root path $ARGV[0] ]");
  my $autoroot = "$ARGV[0]/slaves/";

  my $zsth = $dbh->prepare("INSERT INTO secondaryzones (zone, primaryserver, group_id, status) VALUES (?,?,?,?) RETURNING secondary_id");

  if (opendir AUTOROOT, $autoroot) {
    while (my $zone = readdir AUTOROOT) {
      next if $zone eq '.' || $zone eq '..';
      open PRIMARY, "$autoroot$zone";
      my @primary;
      foreach (<PRIMARY>) {
        chomp;
        push @primary, $_;
      }
      print "$zone => ".join(', ',@primary)."\n" if $verbose;
      $zsth->execute($zone, join(',',@primary), $group, $status);
      my ($zid) = $zsth->fetchrow_array;
      $dnsdb->_log(group_id => $group, secondary_id => $zid, logparent => $logparent,
	entry => "[autoaxfr import] Added secondary zone $zone with primary server".(scalar(@primary) > 1 ? 's' : '').
		" ".join(', ',@primary));
    }
  }

  $dbh->commit;
};
if ($@) {
  $dbh->rollback;
  die "error importing autoaxfr secondary zones: $@";
}
