# -*- Perl -*-

# Base class for DNSDB.pm unit testing
# Sets up DB connection and repopulates it for a consistent test reference
##
# $Id$
# Copyright 2025 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

package DNSDB::DNSTest;
use strict;
use warnings;

use Test::More;

use lib '.';
use DNSDB;

our $dnsdb;
our $dbh;

sub new {
  $dnsdb = new DNSDB(
	dbhost => 'localhost',
	dbname => 'dnstest',
	dbuser => 'dnstest',
	dbpass => 'dnstestpwd',
  );
  ok( defined $dnsdb );
  ok( $dnsdb->isa('DNSDB') );

  ## Prepare the DB
  # Check that we aren't in an obviously production DB before blowing it away.
  # A DB instantiated for these tests should NEVER have more than a handful of domains and maybe 20-30 records.

  my ($dcount) = $dbh->selectrow_array("SELECT count(*) FROM domains");
  BAIL_OUT("# DB looks like it may not be a test DB, found $dcount > 10 domains!\n")
	if $dcount > 10;
  cmp_ok( $dcount, '<=', 10, "domain count: looks like a test DB" );

  my ($rcount) = $dbh->selectrow_array("SELECT count(*) FROM records");
  BAIL_OUT("# DB looks like it may not be a test DB, found $rcount > 30 records!\n")
        if $rcount > 30;
  cmp_ok( $rcount, '<=', 30, "record count: looks like a test DB" );

  $dbh = $dnsdb->{dbh};
}

sub DESTROY {
  $dnsdb->finish;
}

1;
