#!/usr/bin/perl

use strict;
use warnings;
no warnings qw(uninitialized);
use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use DNSBL;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

my $dnsbl = new DNSBL;

my $dbh = $dnsbl->connect;

print "Content-type: text/html\n\n";

my $page;
my $templatedir = "templates";

# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "$templatedir/index.tmpl");
} else {
  $page = HTML::Template->new(filename => "$templatedir/$webvar{page}.tmpl");
}

if ($webvar{page} eq 'report') {
  $page->param(ip => $webvar{ip});
  my $count = $dnsbl->ipexists($webvar{ip});
  $page->param(nreports => $count) if $count;
  $page->param(browsebits => browse($dbh,$webvar{ip}));
  for (my $i=0; $i<3; $i++) {
    my ($block,$org) = $dnsbl->getcontainer($webvar{ip},$i);
    if ($block) {
      $page->param("block$i" => $block);
      $page->param("org$i" => $org);
    }
  }
} elsif ($webvar{page} eq 'dbreport') {
  my $err = '';
  my $count = $dnsbl->report($webvar{ip});
  my $org0id = $dnsbl->orgexists($webvar{org0});
  if (!$org0id) {
    $org0id = $dnsbl->addorg($webvar{org0});
    $page->param(org0 => $webvar{org0});
  }
  if (!$dnsbl->blockexists($webvar{block0})) {
    my $ret = $dnsbl->addblock($webvar{block0}, $org0id, 0);
    $err .= "error adding $webvar{block0}: $ret<br>\n" if $ret;
    $page->param(block0 => $webvar{block0});
  }
# yes, this is grotty.  PTHBTT!
  if ($webvar{block1}) {
    my $org1id = $dnsbl->orgexists($webvar{org1});
    if (!$org1id) {
      $org1id = $dnsbl->addorg($webvar{org1});
      $page->param(org1 => $webvar{org1});
    }
    if (!$dnsbl->blockexists($webvar{block1})) {
      my $ret = $dnsbl->addblock($webvar{block1}, $org1id, 1);
      $err .= "error adding $webvar{block1}: $ret<br>\n" if $ret;
      $page->param(block1 => $webvar{block1});
    }
    if ($webvar{block2}) {
      my $org2id = $dnsbl->orgexists($webvar{org2});
      if (!$org2id) {
        $org2id = $dnsbl->addorg($webvar{org2});
        $page->param(org2 => $webvar{org2});
      }
      if (!$dnsbl->blockexists($webvar{block2})) {
        my $ret = $dnsbl->addblock($webvar{block2}, $org2id, 2);
        $err .= "error adding $webvar{block2}: $ret<br>\n" if $ret;
        $page->param(block2 => $webvar{block2});
      }
    }
  }

  $page->param(ip => $webvar{ip});
  $page->param(err => $err);
}
print $page->output;

exit 0;



## extra subs.  should probably put this in a module somehow to share with browse.cgi

sub browse {
  my $dbh = shift;
  my $ip = shift;

  my $basesql = "SELECT b.block,o.orgname,b.listme,o.listme,b.comments,o.comments ".
	"FROM blocks b INNER JOIN orgs o ON b.orgid=o.orgid ".
	"WHERE b.block ";

  my $sth0 = $dbh->prepare($basesql." >> ? AND b.level=0 ORDER BY block");
  my $sth1 = $dbh->prepare($basesql." <<= ? AND b.level=1 ORDER BY block");
  my $sth2 = $dbh->prepare($basesql." <<= ? AND b.level=2 ORDER BY block");
  my $sthiplist = $dbh->prepare("select * from iplist where ip <<= ? order by ip");

  my %ipseen;
  my $out = '';

  my $tmpl0 = new HTML::Template(filename => 'templates/browse-block.tmpl');

  $sth0->execute($ip);
  while (my ($block0,$org0,$listmeb0,$listmeo0,$bcomments0,$ocomments0) = $sth0->fetchrow_array) {
    $tmpl0->param(lvlclass => 'lvl0'.($dnsbl->autolist_block($block0) ? ' auto0' : ''));
    $tmpl0->param(netclass => ($listmeb0 ? 'b0list' : ''));
    $tmpl0->param(net => $block0);
    $tmpl0->param(orgclass => ($listmeo0 ? 'b0org' : ''));
    $tmpl0->param(org => $org0);
    $tmpl0->param(bcomment => $bcomments0) if $bcomments0;
    $tmpl0->param(ocomment => $ocomments0) if $ocomments0;
    $sth1->execute($block0);
    my $lvl1out = '';
    if ($sth1->rows > 0) {
      while (my ($block1,$org1,$listmeb1,$listmeo1,$bcomments1,$ocomments1) = $sth1->fetchrow_array) {
	my $tmpl1 = new HTML::Template(filename => 'templates/browse-block.tmpl');
	$tmpl1->param(lvlclass => 'lvl1'.($dnsbl->autolist_block($block1) ? ' auto1' : ''));
	$tmpl1->param(netclass => ($listmeb1 ? 'b1list' : ''));
	$tmpl1->param(net => $block1);
	$tmpl1->param(orgclass => ($listmeo1 ? 'b1org' : ''));
	$tmpl1->param(org => $org1);
	$tmpl1->param(bcomment => $bcomments1) if $bcomments1;
	$tmpl1->param(ocomment => $ocomments1) if $ocomments1;
	$tmpl1->param(indent => '  ');
        my $lvl2out = '';
	$sth2->execute($block1);
	if ($sth2->rows > 0) {
	  while (my ($block2,$org2,$listmeb2,$listmeo2,$bcomments2,$ocomments2) = $sth2->fetchrow_array) {
	    my $tmpl2 = new HTML::Template(filename => 'templates/browse-block.tmpl');
	    $tmpl2->param(lvlclass => 'lvl2'.($dnsbl->autolist_block($block2) ? ' auto2' : ''));
	    $tmpl2->param(netclass => ($listmeb2 ? 'b2list' : ''));
	    $tmpl2->param(net => $block2);
	    $tmpl2->param(orgclass => ($listmeo2 ? 'b2org' : ''));
	    $tmpl2->param(org => $org2);
	    $tmpl2->param(bcomment => $bcomments2) if $bcomments2;
	    $tmpl2->param(ocomment => $ocomments2) if $ocomments2;
	    $tmpl2->param(indent => '    ');
	    $sthiplist->execute($block2);
	    my @iprows;
	    while (my @data4 = $sthiplist->fetchrow_array) {
	      my %iprow;
	      $iprow{ip} = $data4[0];
	      $iprow{ipcount} = $data4[1];
	      $iprow{indent} = '    ';
#       ip        | count | s4list |             added
	      push @iprows, \%iprow;
	      $ipseen{$data4[0]} = 1;
	    }
	    $tmpl2->param(iplist => \@iprows);
	    $lvl2out .= $tmpl2->output;
	  }
	}

	$sthiplist->execute($block1);
	my @iprows;
	while (my @data4 = $sthiplist->fetchrow_array) {
	  next if $ipseen{$data4[0]};
	  my %iprow;
	  $iprow{ip} = $data4[0];
	  $iprow{ipcount} = $data4[1];
	  $iprow{indent} = '  ';
#       ip        | count | s4list |             added
	  push @iprows, \%iprow;
	  $ipseen{$data4[0]} = 1;
	}
	$tmpl1->param(iplist => \@iprows);
	$tmpl1->param(subs => $lvl2out);
        $lvl1out .= $tmpl1->output;

      }
    } # sth1->rows
    $sthiplist->execute($block0);
    my @iprows;
    while (my @data4 = $sthiplist->fetchrow_array) {
      next if $ipseen{$data4[0]};
      my %iprow;
      $iprow{ip} = $data4[0];
      $iprow{ipcount} = $data4[1];
      $iprow{indent} = '';
#       ip        | count | s4list |             added
      push @iprows, \%iprow;
      $ipseen{$data4[0]} = 1;
    }
    $tmpl0->param(iplist => \@iprows);
    $tmpl0->param(subs => $lvl1out);
  }

  return $tmpl0->output;
} # end browse()
