#!/usr/bin/perl
# quickndirty browse-the-damned-by-web

use strict;
use warnings;
use DBI;
use CGI::Carp qw(fatalsToBrowser);
use HTML::Template;

use DNSBL;

my $dnsbl = new DNSBL;

# default DB info - all other settings should be loaded from the DB.
my $dbhost = "localhost";
my $dbname = "dnsbl";
my $dbuser = "dnsbl";
my $dbpass = "spambgone";

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
my $cfgname = $ENV{SERVER_NAME}.$ENV{SCRIPT_NAME};
$cfgname =~ s|[./-]|_|g;
$cfgname =~ s|_browse_cgi||;
if (-e "/etc/dnsbl/$cfgname.conf") {
  my $cfg = `cat /etc/dnsbl/$cfgname.conf`;
  ($cfg) = ($cfg =~ /^(.+)$/s);                # avoid warnings, failures, and general nastiness with taint mode
  eval $cfg;
}

my $dbh = $dnsbl->connect($dbhost, $dbname, $dbuser, $dbpass);

print "Content-Type: text/html\n\n";

my $templatedir = $ENV{SCRIPT_FILENAME};
$templatedir =~ s/browse\.cgi//;
$templatedir .= "templates";
$ENV{HTML_TEMPLATE_ROOT} = $templatedir;

my %config;
my $sth = $dbh->prepare("SELECT key,value FROM misc");
$sth->execute;
while (my ($key,$value) = $sth->fetchrow_array) {
  $config{$key} = $value;
}

my $template = HTML::Template->new(filename => "browse.tmpl");

$template->param(pgtitle => $config{pgtitle}) if defined($config{pgtitle});
$template->param(pgcomment => $config{pgcomment}) if defined($config{pgcomment});

my $basesql = "SELECT b.block,o.orgname,b.listme,o.listme,b.comments,o.comments ".
	"FROM blocks b INNER JOIN orgs o ON b.orgid=o.orgid ".
	"WHERE b.parent = ";
my $sth0 = $dbh->prepare($basesql."'0/0' AND b.level=0 ORDER BY block");
#my $sth0 = $dbh->prepare($basesql."'64/8' AND b.level=0 ORDER BY block");
my $sth1 = $dbh->prepare($basesql."? AND b.level=1 ORDER BY block");
my $sth2 = $dbh->prepare($basesql."? AND b.level=2 ORDER BY block");
my $sthiplist = $dbh->prepare("select * from iplist where parent = ? order by ip");

my %ipseen;

my $out = '';

$sth0->execute;
while (my ($block0,$org0,$listmeb0,$listmeo0,$bcomments0,$ocomments0) = $sth0->fetchrow_array) {
  my $tmpl0 = new HTML::Template(filename => "browse-block.tmpl");
  $tmpl0->param(lvlclass => 'lvl0'.($dnsbl->autolist_block($block0) ? ' auto0' : ''));
  $tmpl0->param(netclass => ($listmeb0 ? 'b0list' : ''));
  $tmpl0->param(net => $block0);
  $tmpl0->param(orgclass => ($listmeo0 ? 'b0org' : ''));
  $tmpl0->param(org => $org0);
  $tmpl0->param(bcomment => $bcomments0) if $bcomments0;
  $tmpl0->param(ocomment => $ocomments0) if $ocomments0;
  $sth1->execute($block0);
  my $lvl1out = '';
  if ($sth1->rows > 0) {
    while (my ($block1,$org1,$listmeb1,$listmeo1,$bcomments1,$ocomments1) = $sth1->fetchrow_array) {
      my $tmpl1 = new HTML::Template(filename => "browse-block.tmpl");
      $tmpl1->param(lvlclass => 'lvl1'.($dnsbl->autolist_block($block1) ? ' auto1' : ''));
      $tmpl1->param(netclass => ($listmeb1 ? 'b1list' : ''));
      $tmpl1->param(net => $block1);
      $tmpl1->param(orgclass => ($listmeo1 ? 'b1org' : ''));
      $tmpl1->param(org => $org1);
      $tmpl1->param(bcomment => $bcomments1) if $bcomments1;
      $tmpl1->param(ocomment => $ocomments1) if $ocomments1;
      $tmpl1->param(indent => '  ');
      my $lvl2out = '';
      $sth2->execute($block1);
      if ($sth2->rows > 0) {
	while (my ($block2,$org2,$listmeb2,$listmeo2,$bcomments2,$ocomments2) = $sth2->fetchrow_array) {
	  my $tmpl2 = new HTML::Template(filename => "browse-block.tmpl");
	  $tmpl2->param(lvlclass => 'lvl2'.($dnsbl->autolist_block($block2) ? ' auto2' : ''));
	  $tmpl2->param(netclass => ($listmeb2 ? 'b2list' : ''));
	  $tmpl2->param(net => $block2);
	  $tmpl2->param(orgclass => ($listmeo2 ? 'b2org' : ''));
	  $tmpl2->param(org => $org2);
	  $tmpl2->param(bcomment => $bcomments2) if $bcomments2;
	  $tmpl2->param(ocomment => $ocomments2) if $ocomments2;
	  $tmpl2->param(indent => '    ');
	  $sthiplist->execute($block2);
	  my @iprows;
	  while (my @data4 = $sthiplist->fetchrow_array) {
	    my %iprow;
	    $iprow{ip} = $data4[0];
	    $iprow{ipcount} = $data4[1];
	    $iprow{indent} = '    ';
#       ip        | count | s4list |             added
	    push @iprows, \%iprow;
	    $ipseen{$data4[0]} = 1;
	  }
	  $tmpl2->param(iplist => \@iprows);
	  $lvl2out .= $tmpl2->output;
	}
      }

      $sthiplist->execute($block1);
      my @iprows;
      while (my @data4 = $sthiplist->fetchrow_array) {
	next if $ipseen{$data4[0]};
	my %iprow;
	$iprow{ip} = $data4[0];
	$iprow{ipcount} = $data4[1];
	$iprow{indent} = '  ';
#       ip        | count | s4list |             added
	push @iprows, \%iprow;
	$ipseen{$data4[0]} = 1;
      }
      $tmpl1->param(iplist => \@iprows);
      $tmpl1->param(subs => $lvl2out);
      $lvl1out .= $tmpl1->output;
    }
  } # sth1->rows
  $sthiplist->execute($block0);
  my @iprows;
  while (my @data4 = $sthiplist->fetchrow_array) {
    next if $ipseen{$data4[0]};
    my %iprow;
    $iprow{ip} = $data4[0];
    $iprow{ipcount} = $data4[1];
    $iprow{indent} = '';
#       ip        | count | s4list |             added
    push @iprows, \%iprow;
    $ipseen{$data4[0]} = 1;
  }
  $tmpl0->param(iplist => \@iprows);
  $tmpl0->param(subs => $lvl1out);
  $out .= $tmpl0->output;
}

# probably more efficient ways to do this somewhere...
$template->param(enchilada => $out);
print $template->output;
