#!/usr/bin/perl
# Import a tinydns-formatted URI blacklist
##
# $Id: import-cur.pl 41 2012-03-04 20:52:10Z kdeugau $
# Copyright 2010 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
use DBI;

use URIdb;

my $uridb = new URIdb;

# default DB info - all other settings should be loaded from the DB.
my $dbhost = "localhost";
my $dbname = "uridb";
my $dbuser = "uridb";
my $dbpass = "spambgone";

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
if (-e "/etc/uridb/uridb.conf") {
  my $cfg = `cat /etc/uridb/uridb.conf`;
  ($cfg) = ($cfg =~ /^(.+)$/s);         # avoid warnings, failures, and general nastiness with taint mode
  eval $cfg;
}

my $dbh = $uridb->connect($dbhost, $dbname, $dbuser, $dbpass);

my $datesth = $dbh->prepare("UPDATE urilist SET added=? WHERE uri=?");

my %config;
my $sth = $dbh->prepare("SELECT key,value FROM misc");
$sth->execute;
while (my ($key,$value) = $sth->fetchrow_array) {
  $config{$key} = $value;
}

my @months = ('null','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

my $uridate = 'Tue Nov  9 16:26:29 EST 2010';
my $uricomment;

#my $count = 0;
while (<>) {
  next if /^\s*$/;
  if (/^#/) {
    $uricomment = '';
    if (/^# (\w\w\w \w\w\w  ?\d\d?  ?\d\d?:\d\d:\d\d \w\w\w \d{4})\s*$/) {
      $uridate = $1;
      print "setting date on following URIs to $uridate\n";
    } elsif (m|^# (\d\d\d\d)/(\d\d)/(\d\d?) ?(\d\d:\d\d:?\d?\d?)?$|) {
      $uridate = "$months[$2] $3 $1";
      $uridate .= ($4 ? " $4" : " 10:30:42");
      print "setting date on following URIs to $uridate\n";
    } else {
      chomp;
      s/^#\s+//;
      $uricomment = $_;
      print "setting comment on next URI to $uricomment\n";
    }
    next;
  }
  chomp;
  s/^\+//;
  my ($domain,$list,$rest) = split /:/;
  ($list) = ($list =~ /\.(\d+)$/);
  $domain =~ s/\.uribl\.company\.com$//;
  if (!$uridb->exists($domain)) {
    print "adding $domain, $list\n";
    $uridb->report($domain, $list, $uricomment);
    $datesth->execute($uridate, $domain) or die "bad date-foo: ".$dbh->errstr."\n";
    $dbh->commit;
  } else {
    print "$domain exists, not adding\n";
  }
  $uricomment = '';
#  last if $count++ > 1000;
}
