#!/usr/bin/perl
# quickndirty browse-the-damned-by-web
##
# $Id: browse.cgi 51 2014-12-09 22:11:39Z kdeugau $
# Copyright 2009-2011,2014 Kris Deugau <kdeugau@deepnet.cx>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
use DBI;
use CGI::Carp qw(fatalsToBrowser);
use HTML::Template;

use DNSBL;
use DNSBLweb;

my $dnsbl = new DNSBL;

# default DB info - all other settings should be loaded from the DB.
my $dbhost = "localhost";
my $dbname = "dnsbl";
my $dbuser = "dnsbl";
my $dbpass = "spambgone";

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
my $cfgname = $ENV{SERVER_NAME}.$ENV{SCRIPT_NAME};
$cfgname =~ s|[./-]|_|g;
$cfgname =~ s|_browse_cgi||;
if (-e "/etc/dnsbl/$cfgname.conf") {
  my $cfg = `cat /etc/dnsbl/$cfgname.conf`;
  ($cfg) = ($cfg =~ /^(.+)$/s);                # avoid warnings, failures, and general nastiness with taint mode
  eval $cfg;
}

my $dbh = $dnsbl->connect($dbhost, $dbname, $dbuser, $dbpass);

print "Content-Type: text/html\n\n";

my $templatedir = $ENV{SCRIPT_FILENAME};
$templatedir =~ s/browse\.cgi//;
$templatedir .= "templates";
$ENV{HTML_TEMPLATE_ROOT} = $templatedir;

my %config;
my $sth = $dbh->prepare("SELECT key,value FROM misc");
$sth->execute;
while (my ($key,$value) = $sth->fetchrow_array) {
  $config{$key} = $value;
}

my $template = HTML::Template->new(filename => "browse.tmpl");

$template->param(pgtitle => $config{pgtitle}) if defined($config{pgtitle});
$template->param(pgcomment => $config{pgcomment}) if defined($config{pgcomment});

my $out = DNSBLweb::retlvl($dbh, $dnsbl, 0, block => '0/0');

$template->param(enchilada => $out);
print $template->output;
