#!/usr/bin/perl
# Main add-IP-to-list CGI
##
# $Id: dnsbl.cgi 51 2014-12-09 22:11:39Z kdeugau $
# Copyright 2009-2011,2014 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
no warnings qw(uninitialized);
use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;

use DNSBL;
use DNSBLweb;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

my $dnsbl = new DNSBL;

# try to be friendly to non-US-ASCII characters.  Still need to find what
# difference from RH<->Debian is still at fault.
print $q->header(-charset=>'utf8');

# default DB info - all other settings should be loaded from the DB.
my $dbhost = "localhost";
my $dbname = "dnsbl";
my $dbuser = "dnsbl";
my $dbpass = "spambgone";

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
my $cfgname = $ENV{SERVER_NAME}.$ENV{REQUEST_URI};
$cfgname =~ s|[./-]|_|g;
$cfgname =~ s|_dnsbl_cgi.+||;
$cfgname =~ s|_$||;
if (-e "/etc/dnsbl/$cfgname.conf") {
  my $cfg = `cat /etc/dnsbl/$cfgname.conf`;
  ($cfg) = ($cfg =~ /^(.+)$/s);		# avoid warnings, failures, and general nastiness with taint mode
  eval $cfg;
}

my $dbh = $dnsbl->connect($dbhost, $dbname, $dbuser, $dbpass);

my $page;
my $templatedir = $ENV{SCRIPT_FILENAME};
$templatedir =~ s/dnsbl\.cgi//;
$templatedir .= "templates";
$ENV{HTML_TEMPLATE_ROOT} = $templatedir;

my %config;
my $sth = $dbh->prepare("SELECT key,value FROM misc");
$sth->execute;
while (my ($key,$value) = $sth->fetchrow_array) {
  $config{$key} = $value;
}

# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "index.tmpl");
} else {
  $page = HTML::Template->new(filename => "$webvar{page}.tmpl");
}

$page->param(pgtitle => $config{pgtitle}) if defined($config{pgtitle});
$page->param(pgcomment => $config{pgcomment}) if defined($config{pgcomment});

if ($webvar{page} eq 'report') {
  my $dnsblsiteroot = $ENV{REQUEST_URI};
  $dnsblsiteroot =~ s|/dnsbl\.cgi\?.+|/|;
  $page->param(dnsblsiteroot => $dnsblsiteroot);

  $page->param(ip => $webvar{ip});
  my $count = $dnsbl->ipexists($webvar{ip});
  $page->param(nreports => $count) if $count;
  $page->param(browsebits =>
	DNSBLweb::retlvl($dbh, $dnsbl, 0, ip => $webvar{ip}, block => $dnsbl->getcontainer($webvar{ip},0) ));
  for (my $i=0; $i<3; $i++) {
    my ($block,$org) = $dnsbl->getcontainer($webvar{ip},$i);
    if ($block) {
      my ($bcl,$bal) = $dnsbl->islisted($block);
      $page->param("autob$i" => $bcl);
      $page->param("listb$i" => $bal);
      my ($ol) = $dnsbl->islisted($org);
      $page->param("listorg$i" => $ol);
      $page->param("block$i" => $block);
      $page->param("org$i" => $org);
    }
  }
} elsif ($webvar{page} eq 'dbreport') {
  my $dnsblsiteroot = $ENV{REQUEST_URI};
  $dnsblsiteroot =~ s|/dnsbl\.cgi\?.+|/|;
  $page->param(dnsblsiteroot => $dnsblsiteroot);

  my $err = '';
  my $org0id = $dnsbl->orgexists($webvar{org0});
  if (!$org0id) {
    $org0id = $dnsbl->addorg($webvar{org0});
    $page->param(org0 => $webvar{org0});
  }
  if (!$dnsbl->blockexists($webvar{block0})) {
    my $ret = $dnsbl->addblock($webvar{block0}, $org0id, 0);
    $err .= "error adding $webvar{block0}: $ret<br>\n" if $ret;
    $page->param(block0 => $webvar{block0});
  }
# yes, this is grotty.  PTHBTT!
  if ($webvar{block1}) {
    my $org1id = $dnsbl->orgexists($webvar{org1});
    if (!$org1id) {
      $org1id = $dnsbl->addorg($webvar{org1});
      $page->param(org1 => $webvar{org1});
    }
    if (!$dnsbl->blockexists($webvar{block1})) {
      my $ret = $dnsbl->addblock($webvar{block1}, $org1id, 1);
      $err .= "error adding $webvar{block1}: $ret<br>\n" if $ret;
      $page->param(block1 => $webvar{block1});
    }
    if ($webvar{block2}) {
      my $org2id = $dnsbl->orgexists($webvar{org2});
      if (!$org2id) {
        $org2id = $dnsbl->addorg($webvar{org2});
        $page->param(org2 => $webvar{org2});
      }
      if (!$dnsbl->blockexists($webvar{block2})) {
        my $ret = $dnsbl->addblock($webvar{block2}, $org2id, 2);
        $err .= "error adding $webvar{block2}: $ret<br>\n" if $ret;
        $page->param(block2 => $webvar{block2});
      }
    }
  }
  my $count = $dnsbl->report($webvar{ip});

  $page->param(ip => $webvar{ip});
  $page->param(err => $err);

  $page->param(browsebits => 
	DNSBLweb::retlvl($dbh, $dnsbl, 0, ip => $webvar{ip}, block => $dnsbl->getcontainer($webvar{ip},0) ));
}

print $page->output;
