--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: blocks; Type: TABLE; Schema: public; Owner: dnsbl; Tablespace: 
--

CREATE TABLE blocks (
    block cidr NOT NULL,
    listme boolean DEFAULT false,
    orgid integer,
    "level" integer DEFAULT 0,
    comments text DEFAULT ''::text
);


--
-- Name: iplist; Type: TABLE; Schema: public; Owner: dnsbl; Tablespace: 
--

CREATE TABLE iplist (
    ip inet NOT NULL,
    count integer DEFAULT 1,
    s4list boolean DEFAULT false,
    added timestamp with time zone DEFAULT now()
);


--
-- Name: orgs; Type: TABLE; Schema: public; Owner: dnsbl; Tablespace: 
--

CREATE TABLE orgs (
    orgid serial NOT NULL,
    listme boolean DEFAULT false,
    orgname character varying(100) DEFAULT ''::character varying NOT NULL,
    comments text
);


--
-- Name: blocks_pkey; Type: CONSTRAINT; Schema: public; Owner: dnsbl; Tablespace: 
--

ALTER TABLE ONLY blocks
    ADD CONSTRAINT blocks_pkey PRIMARY KEY (block);


--
-- Name: iplist_pkey; Type: CONSTRAINT; Schema: public; Owner: dnsbl; Tablespace: 
--

ALTER TABLE ONLY iplist
    ADD CONSTRAINT iplist_pkey PRIMARY KEY (ip);


--
-- Name: orgs_pkey; Type: CONSTRAINT; Schema: public; Owner: dnsbl; Tablespace: 
--

ALTER TABLE ONLY orgs
    ADD CONSTRAINT orgs_pkey PRIMARY KEY (orgid);


--
-- Name: blocks_orgid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dnsbl
--

ALTER TABLE ONLY blocks
    ADD CONSTRAINT blocks_orgid_fkey FOREIGN KEY (orgid) REFERENCES orgs(orgid);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

