#!/usr/bin/perl
# hack to set new parent column on blocks and iplist tables
##
# $Id: setparents.pl 73 2025-09-05 20:04:46Z kdeugau $
# Copyright 2009-2011,2025 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
use DBI;

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use DNSBL 3.0;

die "Need config argument\n" if !$ARGV[0];
my $cfgname = shift @ARGV;

my $dnsbl = new DNSBL (configfile => "/etc/dnsbl/$cfgname.conf");
$dnsbl->connect;

print "block parents\n";
my $sthplist = $dbh->prepare("SELECT block FROM blocks WHERE level=?");
my $sthclist = $dbh->prepare("UPDATE blocks SET parent=? WHERE level=? AND block << ?");
foreach my $level ((0,1)) {
  $sthplist->execute($level) or die "failed to get blocklist: ".$sthplist->errstr."\n";
  while (my ($block) = $sthplist->fetchrow_array) {
    $sthclist->execute($block,$level+1,$block) or die "failed setparent on $block subs: ".$sthclist->errstr."\n";
  }
}
print " done\n";

print "block counts\n";
my $sthblist = $dbh->prepare("SELECT block FROM blocks");
my $sthcount = $dbh->prepare("UPDATE blocks SET ipcount=(SELECT count(*) FROM iplist WHERE ip << ?) WHERE block = ?");
$sthblist->execute;
while (my ($block) = $sthblist->fetchrow_array) {
  $sthcount->execute($block,$block) or die "failed setcount on $block: ".$sthcount->errstr."\n";
}
print " done\n";

print "ip parents\n";
$sthplist = $dbh->prepare("SELECT block FROM blocks ORDER BY level");
$sthclist = $dbh->prepare("UPDATE iplist SET parent = ? WHERE ip << ?");
$sthplist->execute;
while (my ($block) = $sthplist->fetchrow_array) {
  $sthclist->execute($block,$block);
}

# and yes, we do this in one huge block.
$dbh->commit;
print " done\n";
