#!/usr/bin/perl
# Import a tinydns-formatted URI blacklist
##
# $Id: import-cur.pl 86 2025-09-11 21:57:24Z kdeugau $
# Copyright 2010,2025 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
use DBI;

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use URIdb 2.0;

die "Usage: import-cur.pl <list>\n"
	if !$ARGV[0]

my $cfgname = shift @ARGV;

my $dbh = $uridb->connect(configfile => "/etc/uridb/$cfgname.conf");

my $datesth = $dbh->prepare("UPDATE urilist SET added=? WHERE uri=?");

my @months = ('null','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

my $uridate = 'Tue Nov  9 16:26:29 EST 2010';
my $uricomment;

#my $count = 0;
while (<>) {
  next if /^\s*$/;
  if (/^#/) {
    $uricomment = '';
    if (/^# (\w\w\w \w\w\w  ?\d\d?  ?\d\d?:\d\d:\d\d \w\w\w \d{4})\s*$/) {
      $uridate = $1;
      print "setting date on following URIs to $uridate\n";
    } elsif (m|^# (\d\d\d\d)/(\d\d)/(\d\d?) ?(\d\d:\d\d:?\d?\d?)?$|) {
      $uridate = "$months[$2] $3 $1";
      $uridate .= ($4 ? " $4" : " 10:30:42");
      print "setting date on following URIs to $uridate\n";
    } else {
      chomp;
      s/^#\s+//;
      $uricomment = $_;
      print "setting comment on next URI to $uricomment\n";
    }
    next;
  }
  chomp;
  s/^\+//;
  my ($domain,$list,$rest) = split /:/;
  ($list) = ($list =~ /\.(\d+)$/);
  $domain =~ s/$config{blzone}$//;
  if (!$uridb->exists($domain)) {
    print "adding $domain, $list\n";
    $uridb->report($domain, $list, $uricomment);
    $datesth->execute($uridate, $domain) or die "bad date-foo: ".$dbh->errstr."\n";
    $dbh->commit;
  } else {
    print "$domain exists, not adding\n";
  }
  $uricomment = '';
#  last if $count++ > 1000;
}
