#!/usr/bin/perl
# Web UI for adding URIs to blacklist
##
# $Id: uridb.cgi 86 2025-09-11 21:57:24Z kdeugau $
# Copyright 2010,2025 Kris Deugau <kdeugau@deepnet.cx>
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version. 
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
no warnings qw(uninitialized);

use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use Encode;

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use URIdb 2.0;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

print $q->header(-charset=>'utf8');

#my %status = (0 => "Don't list",
#	2 => "Black",
#	4 => "Grey",
#	8 => "Abused URL shortener/redirector"
#	);

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
my $cfgname = $ENV{SERVER_NAME}.$ENV{REQUEST_URI};
$cfgname =~ s|[./-]|_|g;
$cfgname =~ s|_uridb_cgi.*||;
$cfgname =~ s|_$||;

my $uridb = new URIdb (configfile => "/etc/uridb/$cfgname.conf");

my $page;

my $cgiself = $ENV{SCRIPT_FILENAME};
$cgiself =~ s|.+/([^/]+\.cgi)$|$1|;

my $templatedir = $ENV{SCRIPT_FILENAME};
$templatedir =~ s/$cgiself//;
$templatedir .= "templates";
$ENV{HTML_TEMPLATE_ROOT} = $templatedir;

# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "index.tmpl");
} else {
  $page = HTML::Template->new(filename => "$webvar{page}.tmpl");
}

$page->param(pgtitle => $uridb->{cfg}{pgtitle}) if defined($uridb->{cfg}{pgtitle});
$page->param(pgcomment => $uridb->{cfg}{pgcomment}) if defined($uridb->{cfg}{pgcomment});
$page->param(cgiself => $cgiself);

my $uridbsiteroot = $ENV{REQUEST_URI};
$uridbsiteroot =~ s|/$cgiself\?.+|/|;
$page->param(uridbsiteroot => $uridbsiteroot);

if ($webvar{page} eq 'report') {

  my @dombase = split /\n/m, $webvar{domlist};
  my @domlist;
  my $domcount = 0;
  foreach my $domain (@dombase) {
    my %row;
    ($domain) = split /:/, $domain;
    $domain =~ s/^\+//;
    $domain =~ s/\.uribl.company.com//;
    chomp $domain;
    # now, see if it's multilisted
    if ($domain =~ / on (\w+)\s*$/) {
      my $sub = $1;
      #$domain =~ s/ on \w+\s*$//;
      $domlist[$domcount-1]->{otherlists} .= ",$sub";
      next;
    }
    $row{domindex} = $domcount++;
    $row{domain} = $domain;
    push @domlist, \%row;
  }

  $page->param(domlist => \@domlist);

} elsif ($webvar{page} eq 'dbreport') {

  my $err = '';
  my @domlist;
  my $i = 0;
  while (defined ($webvar{"dom$i"})) {
    my $key = "dom$i";
    my %row;
    $row{domain} = $webvar{$key};
    $row{listnum} = $webvar{$key."type"};
    $row{listtext} = $URIdb::status{$webvar{$key."type"}};
    $row{comment} = $webvar{$key."comment"};
    if ($webvar{$key."type"} != 0) {
      $uridb->report($webvar{$key},$webvar{$key."type"},$webvar{$key."comment"});
    }
    push @domlist, \%row;
    $i++;
  }
  $page->param(domlist => \@domlist);
  $page->param(err => $err);

}

print $page->output;

exit 0;
