#!/usr/bin/perl
# quickndirty browse-the-damned-by-web
##
# $Id: browse.cgi 92 2025-09-16 19:56:31Z kdeugau $
# Copyright 2009-2012,2014,2018,2025 Kris Deugau <kdeugau@deepnet.cx>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##

use strict;
use warnings;
use DBI;
use CGI::Carp qw(fatalsToBrowser);
use CGI::Simple;
use HTML::Template;

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use DNSBL 3.0;
use DNSBLweb;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

# try to be friendly to non-US-ASCII characters.  Still need to find what
# difference from RH<->Debian is still at fault.
print $q->header(-charset=>'utf8');

# Load a config ref containing DB host, name, user, and pass info based on
# from the server name + full script web path.  This allows us to host
# multiple instances without having to duplicate the code.
# This file is a Perl fragment to be processed inline.
my $cfgname = $ENV{SERVER_NAME}.$ENV{SCRIPT_NAME};
$cfgname =~ s|[./-]|_|g;
$cfgname =~ s|_browse_cgi||;
$cfgname =~ s|_$||;

my $dnsbl = new DNSBL (configfile => "/etc/dnsbl/$cfgname.conf");
$dnsbl->connect;

my $block = '';

my $templatedir = $ENV{SCRIPT_FILENAME};
$templatedir =~ s/browse\.cgi//;
$templatedir .= "templates";
$ENV{HTML_TEMPLATE_ROOT} = $templatedir;

# basic validation so we don't try to look up something ridiculous
if ($webvar{block}) {
  $webvar{block} =~ s/\s+//g;
  $block = $webvar{block} if $webvar{block} =~ /^[\d\.]+(?:\/\d+)?$/;
}

if ($block) {
  my $template = HTML::Template->new(filename => "browse.tmpl");

  $template->param(pgtitle => $dnsbl->{misc}{pgtitle}) if defined($dnsbl->{misc}{pgtitle});
  $template->param(pgcomment => $dnsbl->{misc}{pgcomment}) if defined($dnsbl->{misc}{pgcomment});

  my $out;
  if ($block =~ /^[\d\.]+$/) {
    $out = DNSBLweb::retlvl($dbh, $dnsbl, 0, ip => $block, block => $dnsbl->getcontainer($block,0) );
  } else {
    $out = DNSBLweb::retlvl($dbh, $dnsbl, 0, block => $block);
  }

  $template->param(enchilada => $out);
  print $template->output;

} else {
  # refuse to show the whole tree, as in a "real" dataset it's horribly slow.  even a /8 is often "a bit much"
  print qq(
<html>
<head>
<title>$dnsbl->{misc}{pgtitle}</title>
<body>
$dnsbl->{misc}{pgcomment}<br>
);
  if ($webvar{block}) {
    $webvar{block} =~ s{[^\w]+}{_}g;  #neuter any attempts at funky data injection
    print qq(<span style="border: 1px solid #FF0000;">Invalid netblock specification $webvar{block}</span>\n);
  }
print qq(
<form action="browse.cgi" method="POST">
Enter a CIDR netblock to browse.<br>
This does not have to exactly match a netblock entered in the database.<br>
<input name="block">
<input type="submit">
</form>
</body>
</html>
);
}
