#!/usr/bin/perl

use strict;
use warnings;
no warnings qw(uninitialized);
use CGI::Carp qw (fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use DNSBL;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

my %webvar;
# This is probably excessive fiddling, but it puts the parameters somewhere my fingers know about...
foreach ($q->param()) {
  $webvar{$_} = $q->param($_);
}

my $dnsbl = new DNSBL;

my $dbh = $dnsbl->connect;

print "Content-type: text/html\n\n";

my $page;
my $templatedir = "templates";

# decide which page to spit out...
if (!$webvar{page}) {
  $page = HTML::Template->new(filename => "$templatedir/index.tmpl");
} else {
  $page = HTML::Template->new(filename => "$templatedir/$webvar{page}.tmpl");
}

if ($webvar{page} eq 'report') {
  $page->param(ip => $webvar{ip});
  my $count = $dnsbl->ipexists($webvar{ip});
  $page->param(nreports => $count) if $count;
  $page->param(browsebits => browse($dbh,$webvar{ip}));
  for (my $i=0; $i<3; $i++) {
    my ($block,$org) = $dnsbl->getcontainer($webvar{ip},$i);
    if ($block) {
      $page->param("block$i" => $block);
      $page->param("org$i" => $org);
    }
  }
} elsif ($webvar{page} eq 'dbreport') {
  my $err = '';
  my $count = $dnsbl->report($webvar{ip});
  my $org0id = $dnsbl->orgexists($webvar{org0});
  if (!$org0id) {
    $org0id = $dnsbl->addorg($webvar{org0});
    $page->param(org0 => $webvar{org0});
  }
  if (!$dnsbl->blockexists($webvar{block0})) {
    my $ret = $dnsbl->addblock($webvar{block0}, $org0id, 0);
    $err .= "error adding $webvar{block0}: $ret<br>\n" if $ret;
    $page->param(block0 => $webvar{block0});
  }
# yes, this is grotty.  PTHBTT!
  if ($webvar{block1}) {
    my $org1id = $dnsbl->orgexists($webvar{org1});
    if (!$org1id) {
      $org1id = $dnsbl->addorg($webvar{org1});
      $page->param(org1 => $webvar{org1});
    }
    if (!$dnsbl->blockexists($webvar{block1})) {
      my $ret = $dnsbl->addblock($webvar{block1}, $org1id, 1);
      $err .= "error adding $webvar{block1}: $ret<br>\n" if $ret;
      $page->param(block1 => $webvar{block1});
    }
    if ($webvar{block2}) {
      my $org2id = $dnsbl->orgexists($webvar{org2});
      if (!$org2id) {
        $org2id = $dnsbl->addorg($webvar{org2});
        $page->param(org2 => $webvar{org2});
      }
      if (!$dnsbl->blockexists($webvar{block2})) {
        my $ret = $dnsbl->addblock($webvar{block2}, $org2id, 2);
        $err .= "error adding $webvar{block2}: $ret<br>\n" if $ret;
        $page->param(block2 => $webvar{block2});
      }
    }
  }

  $page->param(ip => $webvar{ip});
  $page->param(err => $err);
}
print $page->output;

exit 0;



## extra subs.  should probably put this in a module somehow to share with browse.cgi

sub browse {
  my $dbh = shift;
  my $ip = shift;

  my $basesql = "SELECT b.block,o.orgname,b.listme,o.listme,b.comments,o.comments ".
	"FROM blocks b INNER JOIN orgs o ON b.orgid=o.orgid ".
	"WHERE b.block ";

  my $sth0 = $dbh->prepare($basesql." >> ? AND b.level=0 ORDER BY block");
  my $sth1 = $dbh->prepare($basesql." <<= ? AND b.level=1 ORDER BY block");
  my $sth2 = $dbh->prepare($basesql." <<= ? AND b.level=2 ORDER BY block");
  my $sthiplist = $dbh->prepare("select * from iplist where ip <<= ? order by ip");

  my %ipseen;
  my $out = '';

  $sth0->execute($ip);
  while (my ($block0,$org0,$listmeb0,$listmeo0,$bcomments0,$ocomments0) = $sth0->fetchrow_array) {
    $out .= "<div class=\"lvl0".($dnsbl->autolist_block($block0) ? ' auto0"' : '"').
	"><span".($listmeb0 ? ' class=b0list' : '').">$block0".
	($listmeb0 ? " ($bcomments0)" : '')."</span> ".
	"<span".($listmeo0 ? ' class=b0org' : '').">$org0".
	($listmeo0 ? " ($ocomments0)" : '')."</span>\n";
    $sth1->execute($block0);
    if ($sth1->rows > 0) {
      while (my ($block1,$org1,$listmeb1,$listmeo1,$bcomments1,$ocomments1) = $sth1->fetchrow_array) {
# lvl 1 div open
	$out .= "  <div class=\"lvl1".($dnsbl->autolist_block($block1) ? ' auto1"' : '"').
		"><span".($listmeb1 ? ' class=b1list' : '').">$block1".
		($listmeb1 ? " ($bcomments1)" : '')."</span> ".
		"<span".($listmeo1 ? ' class=b1org' : '').">$org1".
		($listmeo1 ? " ($ocomments1)" : '')."</span>\n";
	$sth2->execute($block1);
	if ($sth2->rows > 0) {
	  while (my ($block2,$org2,$listmeb2,$listmeo2,$bcomments2,$ocomments2) = $sth2->fetchrow_array) {
# lvl 2 div open
	    $out .= "    <div class=\"lvl2".($dnsbl->autolist_block($block2) ? ' auto2"' : '"').
		"><span".($listmeb2 ? ' class=b2list' : '').">$block2".
		($listmeb2 ? " ($bcomments2)" : '')."</span> ".
		"<span".($listmeo2 ? ' class=b2org' : '').">$org2".
		($listmeo2 ? " ($ocomments2)" : '')."</span>\n";
	    $sthiplist->execute($block2);
	    $out .= "      <div class=iplist>\n";
	    while (my @data4 = $sthiplist->fetchrow_array) {
#       ip        | count | s4list |             added
	      $out .= "        $data4[0] ($data4[1])<br>\n";
	      $ipseen{$data4[0]} = 1;
	    }
	    $out .= "      </div>\n";
# lvl2 div close
	    $out .= "    </div>\n";
	  }
	} else {
	  $sthiplist->execute($block1);
	  $out .= "    <div class=iplist>\n";
	  while (my @data4 = $sthiplist->fetchrow_array) {
#       ip        | count | s4list |             added
	    $out .= "      $data4[0] ($data4[1])<br>\n";
	    $ipseen{$data4[0]} = 1;
	  }
	  $out .= "    </div>\n";
	}

	my $sqlalt = "select ip from iplist where ip << ?";
	my $sthalt = $dbh->prepare($sqlalt);
	$sthalt->execute($block1);
	my @newips;
	while (my @data4 = $sthalt->fetchrow_array) {
	  push @newips, $data4[0] if !$ipseen{$data4[0]};
	  $ipseen{$data4[0]} = 1;
	}
	if ($#newips > -1) {
	  $out .= "    <div class=iplist>\n";
	  foreach (@newips) {
	    $out .= "      $_ ($ipseen{$_})<br>\n";
	  }
	  $out .= "    </div>\n";
	}
# lvl 1 div close
	$out .= "  </div>\n";
      }
    } else {
      $sthiplist->execute($block0);
      $out .= "  <div class=iplist>\n";
      while (my @data4 = $sthiplist->fetchrow_array) {
#       ip        | count | s4list |             added
	$out .= "    $data4[0] ($data4[1])<br>\n";
	$ipseen{$data4[0]} = 1;
      }
      $out .= "  </div>\n";
    }

    my $sqlalt = "select ip from iplist where ip << ?";
    my $sthalt = $dbh->prepare($sqlalt);
    $sthalt->execute($block0);
    my @newips;
    while (my @data4 = $sthalt->fetchrow_array) {
      push @newips, $data4[0] if (!$ipseen{$data4[0]});
    }
    if ($#newips > -1) {
      $out .= "  <div class=iplist>\n";
      foreach (@newips) {
	$out .= "    $_<br>\n";
      }
      $out .= "  </div>\n";
    }

    $out .= "</div>\n";
  }

  return $out;
} # end browse()
