#!/usr/bin/perl
# ipdb/cgi-bin/freespace.pl
# Quick hack to calculate aggregate free IP space, and statistic-ify the blocks.
###
# SVN revision info
# $Date: 2005-01-28 19:04:55 +0000 (Fri, 28 Jan 2005) $
# SVN revision $Rev: 142 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2004 - Kris Deugau

use DBI;
use MyIPDB;
use NetAddr::IP;

($dbh,$errstr) = connectDB_My;

print "Content-type: text/plain\n\n";

$tnumfree = $bigrfree = $bigufree = 0;

# General counts first
if ($ARGV[0]) {
  $sth = $dbh->prepare("select * from freeblocks where maskbits >= $ARGV[0] order by maskbits desc");
} else {
  $sth = $dbh->prepare("select * from freeblocks order by maskbits desc");
}
$sth->execute;
while (@data = $sth->fetchrow_array) {
  # cidr,maskbits,city,routed
  $tnumfree++;
  $numfree{"$data[1]"}++;
}

foreach $size (sort {$a cmp $b} keys %numfree) {
  print "/$size: $numfree{$size}\n";
}
print "\n";

for ($i=30; $i>16; $i--) {
  $j = $i-1;
  $numfree{"$j"} += int $numfree{"$i"}/2;
  $numfree{"$i"} -= (int $numfree{"$i"}/2)*2;
}

foreach $size (sort {$a cmp $b} keys %numfree) {
  print "/$size: $numfree{$size}\n";
}
