#!/usr/bin/perl
# -T
# ipdb/cgi-bin/extras/db2rwhois.pl
# Pull data from ipdb and mangle it into RWHOIS
# Initial version 03/26/2004 kdeugau against IPDB v1
###
# Revision info
# $Date: 2005-05-30 20:09:05 +0000 (Mon, 30 May 2005) $
# SVN revision $Rev: 253 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2004,2005 - Kris Deugau

use strict;
use warnings;
use DBI;
use NetAddr::IP;
use MyIPDB;

$ENV{"PATH"} = "/bin;/usr/bin";

my $rwhoisDataPath = "/etc/rwhoisd";

# We'll pull this out of the database instead.  Just make sure our
# master blocks are actually listed....  <g>
#@masterblocks = (
#		(new NetAddr::IP "209.91.128.0/18"),
#		(new NetAddr::IP "66.186.64.0/19"),
#		(new NetAddr::IP "192.168.99.0/24")
#		);

my ($dbh,$msg) = connectDB_My;

# For WHOIS purposes this may not be very useful.  YMMV, we'll see.
#initIPDBGlobals($dbh);

my @masterblocks;

# Fill in data about our master blocks as allocated from ARIN
# We open separate files for each of these as appropriate.
# Note that this ASS-U-MEs that we do not add master IP blocks-
# there should probably be a separate system for doing that.
my $sth = $dbh->prepare("select cidr,ctime from masterblocks;");
$sth->execute;
my $i=0;
GETMASTERS: while (my @data = $sth->fetchrow_array()) {

# Techically, we only need to exclude 204.138.172.0/24, as we "own" all of the other blocks.
  if ($data[0] =~ /^(192.168.0.0|172.16.0.0|10.0.0.0|20[456])/) {
    next GETMASTERS;
  }
  $masterblocks[$i] = new NetAddr::IP $data[0];
  my ($ctime,undef) = split /\s/, $data[1];

print "$masterblocks[$i] $data[1]\n";

  my $date;
  chomp ($date = `/bin/date +"%Y-%m-%d"`);

# Whew!  Ugly little varmint.
  my $masterfilename = "net-".$masterblocks[$i]->addr."-".$masterblocks[$i]->masklen.
    "/data/network/".$masterblocks[$i]->addr."-".$masterblocks[$i]->masklen.".txt";

# Need check here to create tree for netblock?

  open MASTERFILE,">$rwhoisDataPath/$masterfilename";

  print MASTERFILE "ID: NETBLK-ISP.$masterblocks[$i]\n".
  	"Auth-Area: $masterblocks[$i]\n".
	"Network-Name: ISP-".$masterblocks[$i]->network."\n".
	"IP-Network: $masterblocks[$i]\n".
	"IP-Network-Block: ".$masterblocks[$i]->range."\n".
	"Organization: Friendly ISP\n".
	"Tech-Contact: noc\@example.com\n".
	"Admin-Contact: ISP-ARIN-HANDLE\n".
	"Abuse-Contact: abuse\@example.com\n".
	"Created: $ctime\n".
	"Updated: $date\n".
	"Updated-By: noc\@example.com\n";

  close MASTERFILE;
  $i++;
}

# Now read out the data in the "main" delegation list, and check it
# with the master blocks.  We need to do this to decide which rWHOIS
# "net-xxx.xxx.xxx.xxx-mask" tree the data belongs in.

# Make sure to remove the private netblocks from this.
# No use or point in broadcasting our use of them.
$sth = $dbh->prepare("select cidr,custid,type,city,description,createstamp,modifystamp ".
	"from allocations where ".
	"not (cidr <<= '192.168.0.0/16') and ".
	"not (cidr <<= '172.16.0.0/12') and ".
	"not (cidr <<= '10.0.0.0/8') and ".
	"masklen(cidr) <=30");
#" and (custid='6750400' or custid like '%-RES' or custid like '%-BUS')");
$sth->execute;

$i=0;
while (my ($cidr, $custid, $type, $city, $desc, $ctime, $mtime) = $sth->fetchrow_array) {

# We get master block info from @masterblocks.
 # ID: NETBLK-ISP.10.0.0.0/8
 # Auth-Area: 10.0.0.0/8
 # Network-Name: ISP-10.0.2.144
 # IP-Network: 10.0.2.144.144/29
 # IP-Network-Block: 10.0.2.144 - 10.0.2.151
 # Organization: WidgetCorp
 # Tech-Contact: bob@widgetcorp.com
 # Admin-Contact: ISP-ARIN-HANDLE
 # Created: 20040314
 # Updated: 20040314
 # Updated-By: noc@example.com

  # Get the "full" network number
  my $net = new NetAddr::IP $cidr;

# Assumptions:  All data in ipdb is public
# If not, we need another field to indicate "public/private".

  foreach my $master (@masterblocks) {
    if ($master->contains($net)) {

# Whew!  Ugly little varmint.
      my $masterfilename = "net-".$master->addr."-".$master->masklen.
	"/data/network/".$master->addr."-".$master->masklen.".txt";

      open MASTERFILE,">>$rwhoisDataPath/$masterfilename"
        or print "File open error: '$!' on '$rwhoisDataPath/$masterfilename'\n";

# cidr custid type city description notes maskbits

# Creation date in record to eventually be "correct";  near-term will
# be master's creation date;  immediate is today's date.
my $date;
      chomp ($date = `/bin/date +"%Y%m%d"`);
if ($desc =~ /^\s*$/) { $desc = 'Friendly ISP'; }
#print "$i:\t$net in $master\n";

      print MASTERFILE "---\nID: NETBLK-ISP.$master\n".
  	"Auth-Area: $master\n".
	"Network-Name: ISP-".$net->network."\n".
	"IP-Network: $net\n".
	"IP-Network-Block: ".$net->range."\n".
	"Organization: $desc\n".
#	"Tech-Contact: $data[9]\n".
	"Tech-Contact: abuse\@example.com\n".
	"Admin-Contact: ISP-ARIN-HANDLE\n".
	"Created: $ctime\n".
	"Updated: $mtime\n".
	"Updated-By: noc\@example.com\n";
    }
  }



  #  print "$data[0]\t| $data[1]\t| $data[2]\t| $data[3]\t| $data[4]\t| ".
  #	"$data[5]\t| $data[6]\t| $data[7]\t| $data[8]\t| $data[9]\n";
  #  print "$data[0]\t| $data[1]\t| $data[2]\t| $data[3]\t| $data[4]\t| ".
  #	"$data[5]\t| $data[6]\t| $data[7]\t| $data[8]\n";
  $i++;
} # while fetchrow_array()


$dbh->disconnect;
