#!/usr/bin/perl

use strict;		
use warnings;	

#file snCalc.cgi	little subnet calculator app

my %webvar = parse_post();
my $input;

print "Content-Type: text/html\n\n";

open(HTML, "../startsn.html")|| die "Could not open starsn.html :$!";
my $start = join('', <HTML>);
close(HTML);
print $start;

if($webvar{input} =~ m/(\d\d)/)
{
	$input = 1*$1;
}
else
{
	$input = 29;
}

if ($input > 32 || $input < 24)
{
	printAndExit("Don't know what to do with '$input' as a masklength.");
}
else
{		
		my $ltinput = $input -1;
		my $gtinput = $input +1;
		print qq(	<div class="center">
		<table align="center" cellspacing="3" cellpadding="3"><tr>
		<td class="heading" align="center"> Results for /$ltinput</td><td class="heading" align="center"> Results for /$input</td><td class="heading" align="center"> Results for /$gtinput</td></tr>
		);	

		if( $input =~ m|.*24.*|){
			$input = 256;
			$ltinput =128;
			undef($gtinput);
		}
		elsif( $input =~ m|.*25.*|){
			$input = 128;
			$ltinput = 64;
			$gtinput = 256;
		}
		elsif( $input =~ m|.*26.*|){
			$input = 64;
			$ltinput = 32;
			$gtinput = 128;
		}
		elsif( $input =~ m|.*27.*|){
			$input = 32;
			$ltinput = 16;
			$gtinput = 64;
		}
		elsif( $input =~ m|.*28.*|){
			$input = 16;
			$ltinput = 8;
			$gtinput = 32;
		}
		elsif( $input =~ m|.*29.*|){
			$input = 8;
			$ltinput = 4;
			$gtinput = 16;
		}
		elsif( $input =~ m|.*30.*|){
			$input = 4;
			$ltinput = 2;
			$gtinput = 8;
		}
		elsif( $input =~ m|.*31.*|){
			$input = 2;
			$ltinput = 1;
			$gtinput = 4;
		}
		elsif( $input =~ m|.*32.*|){
			$input = 1;
			$gtinput = 2;
			undef($ltinput);
		}

		my ($center, $left, $right) = ('','','');
		my $subnet;
		
		#add the subnet masks
		
	        if($input) 
	        {		
		  $subnet = 256 - $input;
		  $center = qq(<div style="background-color: #00ff00">255.255.255.$subnet </div>);
	        }

	        if($ltinput)
		{
		  $subnet = 256 - $ltinput;
		  $right = qq(<div style="background-color: #00ff00">255.255.255.$subnet</div>);
		}
	        if($gtinput)
		{
		  $subnet = 256 - $gtinput;
		  $left = qq(<div style="background-color: #00ff00">255.255.255.$subnet</div>);
		}


		for(my $i = 0; $i < 256; $i++)
		{
			#left display -- one less than requested
			if(defined($gtinput) && $i % $gtinput == 0)
			{
				my $upper = $i + $gtinput -1;
				$left .= "x.x.x.$i - x.x.x.$upper</br>\n";
			}

			#center display -- the one requested
			if($i % $input == 0 )
			{
				my $upper = $i + $input - 1;
				$center .= "x.x.x.$i - x.x.x.$upper&nbsp;&nbsp;</br>\n";
			}

			#right display -- one more than requested
			if(defined($ltinput) && $i % $ltinput == 0)
			{
				my $upper = $i + $ltinput -1;
				$right .= "x.x.x.$i - x.x.x.$upper&nbsp;&nbsp;</br>\n";
			}
		}
		
		print qq(<tr><td valign="top" >$left</td>
				<td valign="top" bgcolor="#d0e0e0">$center</td>
				<td valign="top" >$right</td></tr>
				);
		print "</table>\n";

		print '<input type="button" value="Back" onclick="history.go(-1)" class="heading"></div></body></html>';
	
}


sub parse_post {
  my $buffer;
  if ($ENV{'REQUEST_METHOD'} eq "GET") {
    $buffer=$ENV{'QUERY_STRING'}
  } elsif ($ENV{'REQUEST_METHOD'} eq 'POST' && $ENV{'CONTENT_TYPE'} eq "application/x-www-form-urlencoded") {
    read(STDIN, $buffer, $ENV{CONTENT_LENGTH});
  } else {
    $buffer = $ENV{'QUERY_STRING'};
    $buffer || read(STDIN, $buffer, $ENV{CONTENT_LENGTH});
  }
  my @pairs = split(/&/, $buffer);
  my %webvarLocal;
  foreach my $pair (@pairs) {
    my ($name, $value) = split(/=/, $pair);
    $name  =~ tr/+/ /;
    $name  =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/\'/\\\'/g;
    $webvarLocal{$name} = $value;
  }
  return %webvarLocal;
}
sub printAndExit
{
	my $errStr = $_[0];
	print qq(
	<center><p class="regular"> $errStr </p>
	<input type="button" value="Back" onclick="history.go(-1)" class="heading">
	</center>
	);
	exit(0);
}
