#!/usr/bin/perl
# ipdb/cgi-bin/newcity.cgi
# Add new city to database
###
# SVN revision info
# $Date: 2007-01-05 15:33:00 +0000 (Fri, 05 Jan 2007) $
# SVN revision $Rev: 355 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2004,2005 - Kris Deugau

use strict;
use warnings;
#use CGI::Carp qw(fatalsToBrowser);
use DBI;
use CommonWeb qw(:ALL);
use MyIPDB;
#use POSIX qw(ceil);
use NetAddr::IP;

use Sys::Syslog;

openlog "IPDB","pid","local2";

# Collect the username from HTTP auth.  If undefined, we're in a test environment.
my $authuser;
if (!defined($ENV{'REMOTE_USER'})) {
  $authuser = '__temptest';
} else {
  $authuser = $ENV{'REMOTE_USER'};
}

my %webvar = parse_post();
cleanInput(\%webvar);

my ($dbh,$errstr) = connectDB_My;
my $sth;

print "Content-type: text/html\n\n";

if ($webvar{pop} eq 'on') {
  $sth = $dbh->prepare("insert into cities (city,routing) values ('$webvar{city}','y')");
} else {
  $sth = $dbh->prepare("insert into cities (city,routing) values ('$webvar{city}','n')");
}
$sth->execute;

if ($sth->err) {
  print "Error adding city to database: ".$sth->errstr;
  mailNotify('kdeugau@vianet.ca',"IPDB city add failure",
	"$authuser could not add city '$webvar{city}' to database: ".$sth->errstr);
  syslog "err", "$authuser could not add city '$webvar{city}' to database: ".$sth->errstr;
} else {
  print "City added.  Closing this window should refresh the page.";
  syslog "notice", "$authuser added city/location '$webvar{pop}'".
	(($webvar{pop} eq 'on') ? ' as POP location' : '');
}

finish($dbh);
