#!/usr/bin/perl -W -T
# db2rwhois.pl
# Pull data from ipdb and mangle it into RWHOIS
# Initial version 03/26/2004 kdeugau

use DBI;
use NetAddr::IP;

$ENV{"PATH"} = "/bin;/usr/bin";

# We'll pull this out of the database instead.  Just make sure our
# master blocks are actually listed....  <g>
#@masterblocks = (
#		(new NetAddr::IP "10.0.0.0/8"),
#		(new NetAddr::IP "172.16.0.0/12"),
#		(new NetAddr::IP "192.168.0.0/16")
#		);

$dbh = DBI->connect("dbi:mysql:ipdb", "root", "")
  or die $DBI::errstr;

# Fill in data about our master blocks as allocated from ARIN
# We open separate files for each of these as appropriate.
# Note that this ASS-U-MEs that we do not add master IP blocks-
# there should probably be a separate system for doing that.
$sth = $dbh->prepare("select * from masterblocks;");
$sth->execute;
$i=0;
while (@data = $sth->fetchrow_array()) {
  # Get the "full" network number+CIDR mask
  $cidr = $data[0].".".$data[2].$data[1];

  $masterblocks[$i] = new NetAddr::IP $cidr;

  chomp ($date = `/bin/date +"%Y%m%d"`);

# Whew!  Ugly little varmint.
  $masterfilename = "net-".$masterblocks[$i]->addr."-".$masterblocks[$i]->masklen.
    "/data/network/".$masterblocks[$i]->addr."-".$masterblocks[$i]->masklen.".txt";

  open MASTERFILE,">$masterfilename";

  print MASTERFILE "ID: NETBLK-ISP.$masterblocks[$i]\n".
  	"Auth-Area: $masterblocks[$i]\n".
	"Network-Name: ISP-".$masterblocks[$i]->network."\n".
	"IP-Network: $masterblocks[$i]\n".
	"IP-Network-Block: ".$masterblocks[$i]->range."\n".
	"Organization: $data[3]\n".
	"Tech-Contact: $data[9]\n".
	"Admin-Contact: ISP-ARIN-HANDLE\n".
	"Created: 20040401000000000\n".
	"Updated: $date\n".
	"Updated-By: noc\@example.com\n";

  close MASTERFILE;
  $i++;
}

# Now read out the data in the "main" delegation list, and check it
# with the master blocks.  We need to do this to decide which rWHOIS
# "net-xxx.xxx.xxx.xxx-mask" tree the data belongs in.

#$sth = $dbh->prepare("select * from blocks;");
$sth = $dbh->prepare("select * from tmpblocks;");
$sth->execute;

while (@data = $sth->fetchrow_array()) {

# We get master block info from @masterblocks.
 # ID: NETBLK-ISP.10.0.0.0/8
 # Auth-Area: 10.0.0.0/8
 # Network-Name: ISP-10.0.2.144
 # IP-Network: 10.0.2.144.144/29
 # IP-Network-Block: 10.0.2.144 - 10.0.2.151
 # Organization: WidgetCorp
 # Tech-Contact: bob@widgetcorp.com
 # Admin-Contact: ISP-ARIN-HANDLE
 # Created: 20040314
 # Updated: 20040314
 # Updated-By: noc@example.com

  # Get the "full" network number
  $netnum = $data[0].".".$data[2];

  $cidr = $netnum.$data[1];

  $net = new NetAddr::IP $cidr;

# Assumptions:  All data in ipdb is public
# If not, we need another field to indicate "public/private".

  foreach $master (@masterblocks) {
    if ($master->contains($net)) {

# Whew!  Ugly little varmint.
      $masterfilename = "net-".$master->addr."-".$master->masklen.
	"/data/network/".$master->addr."-".$master->masklen.".txt";

      open MASTERFILE,">>$masterfilename";

      chomp ($date = `/bin/date +"%Y%m%d"`);
      print MASTERFILE "---\nID: NETBLK-ISP.$master\n".
  	"Auth-Area: $master\n".
	"Network-Name: ISP-".$net->network."\n".
	"IP-Network: $net\n".
	"IP-Network-Block: ".$net->range."\n".
	"Organization: $data[5]\n".
#	"Tech-Contact: $data[9]\n".
	"Tech-Contact: abuse\@example.com\n".
	"Admin-Contact: ISP-ARIN-HANDLE\n".
	"Created: <date from db> (or today's date?)\n".
	"Updated: $date\n".
	"Updated-By: noc\@example.com\n";
    }
  }



  #  print "$data[0]\t| $data[1]\t| $data[2]\t| $data[3]\t| $data[4]\t| ".
  #	"$data[5]\t| $data[6]\t| $data[7]\t| $data[8]\t| $data[9]\n";
  #  print "$data[0]\t| $data[1]\t| $data[2]\t| $data[3]\t| $data[4]\t| ".
  #	"$data[5]\t| $data[6]\t| $data[7]\t| $data[8]\n";

} # while fetchrow_array()


$dbh->disconnect;
