# spec file for IPDB
# $Id: ipdb.spec 433 2010-07-16 21:48:19Z kdeugau $

%define errata 99

# A collection of magic to set the release "number" such that dist upgrades will, erm, upgrade.
%if %{?debdist:0}%{?!debdist:1}
%define debdist etch
%endif
%if "%{debdist}" == "sarge"
%define errata 0
%endif
%if "%{debdist}" == "dapper"
%define errata 1
%endif
%if "%{debdist}" == "etch"
%define errata 2
%endif
%if "%{debdist}" == "lenny"
%define errata 3
%endif
%if "%{debdist}" == "squeeze"
%define errata 4
%endif
%if %{?relnum:0}%{?!relnum:1}
%define relnum 1
%endif

%define release %{relnum}.%{errata}%{debdist}

Summary: IP Database
Name: ipdb
Version: #VERSION#
Release: %{release}
Group: Applications/System
Source: ipdb-#VERSION#.tar.gz
Packager: Kris Deugau <kdeugau@deepnet.cx>
BuildRoot: /var/tmp/%{name}-%{version}
License: GPL 3+
BuildArch: noarch
Requires: perl(NetAddr::IP) >= 4, perl(DBD:Pg)
%if %{_vendor} == "debbuild"
Recommends: perl(Sys::SigAction)
%endif

%description
A web-based IP address allocation management tool

%prep
%setup

%build

%install
# le sigh.  rpm's makeinstall macro includes the buildroot in the dirs, so it will break here.  :/
make \
        prefix=%{_prefix} \
        exec_prefix=%{_exec_prefix} \
        bindir=%{_bindir} \
        sbindir=%{_sbindir} \
        sysconfdir=%{_sysconfdir} \
        datadir=%{_datadir} \
        includedir=%{_includedir} \
        libdir=%{_libdir} \
        libexecdir=%{_libexecdir} \
        localstatedir=%{_localstatedir} \
        sharedstatedir=%{_sharedstatedir} \
        mandir=%{_mandir} \
        infodir=%{_infodir} \
  install DESTDIR=$RPM_BUILD_ROOT

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]; then
  rm -rf $RPM_BUILD_ROOT
fi

%files
%{_libdir}/ipdb
%attr(-,-,0755) %{_libdir}/ipdb/cgi-bin/*.cgi
%attr(-,-,0755) %{_libdir}/ipdb/cgi-bin/*.pl
%attr(-,-,0755) %{_libdir}/ipdb/cgi-bin/extras/*.pl
%config %{_sysconfdir}/ipdb/MyIPDB.pm
%{_sysconfdir}/ipdb

%changelog
* Mon Jun 28 2010  Kris Deugau <kdeugau@deepnet.cx> 2.6-1
- Initial package
