#!/usr/bin/perl
# Most of the file rDNS.html should be copied exactly from DNSAdmin.  This
# script creates rDNS.html from the source file in SVN at
# https://secure.deepnet.cx/svn/dnsadmin/trunk/reverse-patterns.html

use strict;
use warnings;

use LWP;

my $ua = LWP::UserAgent->new;
$ua->agent("ipdb-gen-rDNS");
my $req = HTTP::Request->new(GET => "https://secure.deepnet.cx/svn/dnsadmin/trunk/reverse-patterns.html");
my $res = $ua->request($req);
die "Failed to retrieve source file from SVN: ".$res->status_line."\n" if !$res->is_success;

my $srcfile = $res->content;

open LRDNS, ">rDNS.html.new";
print LRDNS << 'EOH'
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
        <title>IP Database Reverse DNS Help</title>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <link rel="stylesheet" type="text/css" href="ipdb.css">
        <link rel="stylesheet" type="text/css" href="local.css">
</head>
<body>

<!--
  This file is generated, and should not be edited directly.  Edit gen-rDNS.pl to edit the header below, and 
  see https://secure.deepnet.cx/svn/dnsadmin/trunk/reverse-patterns.html for the tables.
-->

<p>The IP Database can pass reverse DNS information back and forth to a DNS management backend to simplify
maintenance of the reverse DNS records associated with the IPs being managed.</p>

<p>Several shortcuts can be used when specifying a pattern for an IPv4 netblock, which will be expanded to
actual DNS records by the DNS management system.</p>

<p>Entries should generally only be present in the "Per-IP reverse entries" section if they are different from
the block pattern.</p>

<p>Template patterns are not supported for IPv6 allocations due to the size of the address space and typical
size of allocations.</p>

<p>"(cached)" or "[local]" indicates the rDNS information shown came from IPDB records,
and not the DNS management utility.  It may be out of date, or DNS
management integration may be missing or incomplete for this block.</p>

EOH
;

my @l = split "\n", $srcfile;
my $flag = 0;
foreach my $line(@l) {
  $flag = 1 if $line eq '<!-- rdns pattern table -->';
  $flag = 0 if $line eq '<!-- done rdns pattern table -->';
  next unless $flag;
  print LRDNS "$line\n";
}
print LRDNS "<!-- done rdns pattern table -->\n\n</body>\n</html>\n";
close LRDNS;

# now that we have a supposedly good copy, move the .new to the canonical file.

rename "rDNS.html.new", "rDNS.html";
