#!/usr/bin/perl
# Shell-based script to allocate arbitrary block
###
# SVN revision info
# $Date: 2017-08-15 17:53:23 +0000 (Tue, 15 Aug 2017) $
# SVN revision $Rev: 906 $
# Last update by $Author: kdeugau $
###

use strict;
use warnings;
use DBI;
use NetAddr::IP;

use Sys::Syslog;

# don't remove!  required for GNU/FHS-ish install from tarball
##uselib##

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use MyIPDB;

openlog "IPDBshell","pid","$IPDB::syslog_facility";

# Collect the username from the environment.  If undefined, something
# is Officially Hosed.
my $authuser;
if (!defined($ENV{'USER'})) {
  die "Bad environment!  USER not defined.\n";
} else {
  $authuser = $ENV{'USER'};
}

# Why not a global DB handle?  (And a global statement handle, as well...)
# Use the connectDB function, otherwise we end up confusing ourselves
my $ip_dbh;
my $sth;
my $errstr;
($ip_dbh,$errstr) = connectDB_My;
die "Failed to connect to database: $errstr\n"
	if !$ip_dbh;

checkDBSanity($ip_dbh);
initIPDBGlobals($ip_dbh);

# Hokay, now we can start to handle the allocation.

my ($cidr, $type, $vrf, $custid, $city, $desc) = @ARGV;
my ($fbid, $fbparent);
# Check ARGV.  We need some information to determine what to allocate.
if (!defined($vrf)) {
  # Usage message
  print "Usage:  allocate.pl <IP/subnet> <Type> <VRF> [CustID] [City] [\"Description\"]\n".
	"	IP/subnet, Type, and VRF are required\n".
	"	Further information can be entered via the web interface\n";
  exit;
} else {

  $cidr = new NetAddr::IP $cidr;
  ($fbid,$fbparent) = $ip_dbh->selectrow_array(
	"SELECT id,parent_id FROM freeblocks WHERE cidr >>= ? AND vrf = ?", undef, "$cidr", $vrf)
	or die "Couldn't find a free block to match '$cidr' in $vrf\n";
  if (!$desc) {
    # Default desc
    $desc = "DEFAULT: $disp_alloctypes{$type}";
  }
  if (!$city) {
    # Default city taken from parent allocation
    ($city) = $ip_dbh->selectrow_array("SELECT city FROM allocations WHERE id = ?", undef, $fbparent);
  }
  if (!$custid) {
    # See if the type has a default custID....
    $custid = $ip_dbh->selectrow_array("SELECT def_custid FROM alloctypes WHERE type = ?", undef, $type);
    # ... and if not, make it REAL obvious this needs to be fixed.
    $custid = "FIXME" if !$custid;
  }
}

print "Allocating $cidr as $type to $custid in $city: '$desc'\n";

my %insert_args = (
        cidr            => "$cidr",
        fbid            => $fbid,
        parent          => $fbparent,
        custid          => $custid,
        type            => $type,
        city            => $city,
        desc            => $desc,
        vrf             => $vrf,
        user            => $authuser,
);

my ($code,$msg) = allocateBlock($ip_dbh, %insert_args);

if ($code eq 'OK') {
  print "Allocation OK!\n";
  syslog "notice", "($authuser) Allocated '$cidr' to '$custid' as '$type'";
} else {
  print "Allocation failed!  IPDB::allocateBlock said:\n$msg\n";
  syslog "err", "($authuser) Allocation of '$cidr' to '$custid' as '$type' failed: '$msg'";
}

# Close it down.
finish($ip_dbh);
