#!/usr/bin/perl
# ipdb/cgi-bin/newnode.cgi
# Add new wifi tower or fibre demarc switch ("node") to database
###
# SVN revision info
# $Date: 2025-04-10 21:22:24 +0000 (Thu, 10 Apr 2025) $
# SVN revision $Rev: 955 $
# Last update by $Author: kdeugau $
###
# Copyright (C) 2010 - Kris Deugau

use strict;
use warnings;
#use CGI::Carp qw(fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use DBI;
#use POSIX qw(ceil);
use NetAddr::IP;
use Sys::Syslog;

# don't remove!  required for GNU/FHS-ish install from tarball
##uselib##

# push "the directory the script is in" into @INC
use FindBin;
use lib "$FindBin::RealBin/";

use MyIPDB;

openlog "IPDB","pid","$IPDB::syslog_facility";

# Collect the username from HTTP auth.  If undefined, we're in a test environment.
my $authuser;
if (!defined($ENV{'REMOTE_USER'})) {
  $authuser = '__temptest';
} else {
  $authuser = $ENV{'REMOTE_USER'};
}

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

# Convenience;  saves changing all references to %webvar
##fixme:  tweak for handling <select multiple='y' size=3> (list with multiple selection)
my %webvar = $q->Vars;

my ($dbh,$errstr) = connectDB_My;
my $sth;

$ENV{HTML_TEMPLATE_ROOT} = '../templates';

my $page = HTML::Template->new(filename => "newnode.tmpl");
print "Content-type: text/html\n\n";

if ($webvar{nodename}) {
  $webvar{nodename} =~ tr/a-z/A-Z/;
  $page->param(nodename => $webvar{nodename});
  my @nc = $dbh->selectrow_array("SELECT node_ip FROM nodes WHERE node_name = ?", undef, $webvar{nodename});
  if (@nc) {
    $page->param(err => "Node with that name already exists with IP $nc[0].");
  } else {
    $sth = $dbh->prepare("insert into nodes (node_type,node_name,node_ip) values (?,?,?)");
    $webvar{nodeip} =~ s/^\s*//;
    $webvar{nodeip} =~ s/\s*$//;
    $sth->execute($webvar{type}, $webvar{nodename}, $webvar{nodeip});
    if ($sth->err) {
      $page->param(err => $sth->errstr);
      my $msg = "$authuser could not add node '$webvar{nodename}','$webvar{type}' to database: ".$sth->errstr;
      mailNotify($dbh, 'f:nno', "IPDB node add failure", $msg);
      syslog "err", $msg;
    } else {
      syslog "notice", "$authuser added node '$webvar{nodename}'";
    }
  } # @nc == 0
}

print $page->output;

finish($dbh);
