#!/usr/bin/perl

use strict;		
use warnings;	
use CGI::Carp qw(fatalsToBrowser);
use CGI::Simple;
use NetAddr::IP;
use CommonWeb qw(:ALL);;

#file snCalc.cgi	little subnet calculator app

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

# Convenience;  saves changing all references to %webvar
##fixme:  tweak for handling <select multiple='y' size=3> (list with multiple selection)
my %webvar = $q->Vars;

my $input;

print "Content-Type: text/html\n\n";

open(HTML, "../startsn.html")|| die "Could not open startsn.html :$!";
my $start = join('', <HTML>);
close(HTML);
print $start;

# Clean up input so we don't divide by zero or something equally silly
if ($webvar{input} =~ m/(\d+)/) {
  $input = 1*$1;
  $input = 3 if $input < 3;
  $input = 29 if $input > 29;	# Not doing IPv6 yet...
} else {
  $input = 29;
}

my $ltinput = $input - 1;
my $gtinput = $input + 1;

my $prenet = new NetAddr::IP "0.0.0.0/$ltinput";
my $net = new NetAddr::IP "0.0.0.0/$input";
my $postnet = new NetAddr::IP "0.0.0.0/$gtinput";

print qq(<div class="center">
<table align="center" cellspacing="3" cellpadding="3">
<tr>
	<td class="heading" align="center">Results for /$ltinput</td>
	<td class="heading" align="center">Results for /$input</td>
	<td class="heading" align="center">Results for /$gtinput</td>
</tr>
);

print qq(<tr><td valign="top">\n).
	qq(	<div class="mask">).$prenet->mask."</div>\n".
	qq(	<div class="wildcard">).$prenet->wildcard."</div>\n".
	getranges($ltinput).
	qq(</td>\n<td valign="top" bgcolor="#d0e0e0">\n).
	qq(	<div class="mask">).$net->mask."</div>\n".
	qq(	<div class="wildcard">).$net->wildcard."</div>\n".
	getranges($input).
	qq(</td>\n<td valign="top">).
	qq(	<div class="mask">).$postnet->mask."</div>\n".
	qq(	<div class="wildcard">).$postnet->wildcard."</div>\n".
	getranges($gtinput);

print "</td></tr>\n</table>\n";

print qq(<input type="button" value="Back" onclick="history.go(-1)" class="heading">
</div>
</body>
</html>
);
	
# Just In Case
exit 0;

# subs
sub xrange {
  my $block = shift;
  my $masklen = shift;
  my $data = $block->range;
  if ($masklen >= 24) {
    $data =~ s/\b0\.0\.0\./x.x.x./g;
  } elsif ($masklen >=16) {
    $data =~ s/\b0\.0\.(\d+\.\d+)/x.x.$1/g;
  } elsif ($masklen >=8) {
    $data =~ s/\b0\.(\d+\.\d+\.\d+)/x.$1/g;
  }
  return $data;
} # xrange()


sub getranges {
  my $masklen = shift;
  my $ret = '';
  my $super;
  if ($masklen < 8) {
    $super = new NetAddr::IP "0.0.0.0/0";
  } elsif ($masklen < 16) {
    $super = new NetAddr::IP "0.0.0.0/8";
  } elsif ($masklen < 24) {
    $super = new NetAddr::IP "0.0.0.0/16";
  } else {
    $super = new NetAddr::IP "0.0.0.0/24";
  }
  foreach my $net ($super->split($masklen)) {
    $ret .= "\t".xrange($net,$masklen)."<br />\n";
  }
  return $ret;
} # getranges()
