#!/usr/bin/perl
# ipdb/cgi-bin/search.cgi
# Started splitting search functions (quick and otherwise) from
# main IPDB interface 03/11/2005
###
# SVN revision info
# $Date: 2016-11-02 00:54:09 +0000 (Wed, 02 Nov 2016) $
# SVN revision $Rev: 893 $
# Last update by $Author: kdeugau $
###
# Copyright 2005-2010,2012,2015,2016 - Kris Deugau

use strict;		
use warnings;	
use CGI::Carp qw(fatalsToBrowser);
use CGI::Simple;
use HTML::Template;
use DBI;
use POSIX qw(ceil);
use NetAddr::IP;

# don't remove!  required for GNU/FHS-ish install from tarball
##uselib##

use MyIPDB;

# Don't formally need a username or syslog here.  syslog left active for debugging.
use Sys::Syslog;
openlog "IPDBsearch","pid","$IPDB::syslog_facility";

# ... but we do *use* the username on ACLs now.
# Collect the username from HTTP auth.  If undefined, we're in
# a test environment, or called without a username.
my $authuser;
if (!defined($ENV{'REMOTE_USER'})) {
  $authuser = '__temptest';
} else {
  $authuser = $ENV{'REMOTE_USER'};
}

# Global variables
my $RESULTS_PER_PAGE = 25;

# anyone got a better name?  :P
my $thingroot = $ENV{SCRIPT_FILENAME};
$thingroot =~ s|cgi-bin/search.cgi||;

# Set up the CGI object...
my $q = new CGI::Simple;
# ... and get query-string params as well as POST params if necessary
$q->parse_query_string;

# Convenience;  saves changing all references to %webvar
##fixme:  tweak for handling <select multiple='y' size=3> (list with multiple selection)
my %webvar = $q->Vars;

if (defined($webvar{rpp})) {
  ($RESULTS_PER_PAGE) = ($webvar{rpp} =~ /(\d+)/);
}

# Why not a global DB handle?  (And a global statement handle, as well...)
# Use the connectDB function, otherwise we end up confusing ourselves
my $ip_dbh;
my $sth;
my $errstr;
($ip_dbh,$errstr) = connectDB_My;
if ($ip_dbh) {
  checkDBSanity($ip_dbh);
  initIPDBGlobals($ip_dbh);
}

# Set up some globals
$ENV{HTML_TEMPLATE_ROOT} = $thingroot;
my @templatepath = [ "localtemplates", "templates" ];

## FIXME!
## Pretty much everything from here on down is one giant FIXME
## FIXME!

my $page;
if (!defined($webvar{stype})) {
  $webvar{stype} = "<NULL>";   #shuts up the warnings.
  $page = HTML::Template->new(filename => "search/compsearch.tmpl", path => @templatepath);
} else {
  $page = HTML::Template->new(filename => "search/sresults.tmpl", global_vars => 1, path => @templatepath);
  $page->param(webpath => $IPDB::webpath);
}

my $header = HTML::Template->new(filename => "header.tmpl", path => @templatepath);
$header->param(version => $IPDB::VERSION);
$header->param(addperm => $IPDBacl{$authuser} =~ /a/);
$header->param(webpath => $IPDB::webpath);
print "Content-type: text/html\n\n", $header->output;

# Columns actually returned.  Slightly better than hardcoding it
# in each (sub)select
my $cols = "s.cidr, s.custid, s.type, s.city, s.description, s.id, s.parent_id, s.available, a.vrf";

# Handle the DB error first
if (!$ip_dbh) {
  $page = HTML::Template->new(filename => "dberr.tmpl", path => @templatepath);
  $page->param(errmsg => $errstr);
} elsif ($webvar{stype} eq 'q') {
  # Quick search.

  if (!$webvar{input}) {
    # No search term.  Display everything.
    viewBy('all', '');
  } else {
    # Search term entered.  Display matches.
    # We should really sanitize $webvar{input}, no?
    my $searchfor;
    # Chew up leading and trailing whitespace
    $webvar{input} =~ s/^\s+//;
    $webvar{input} =~ s/\s+$//;
    if ($webvar{input} =~ /^\d+$/) {
      # All-digits, new custID
      $searchfor = "cust";
    } elsif ($webvar{input} =~ /^[\d\.]+(\/\d{1,3})?$/) {
      # IP addresses should only have numbers, digits, and maybe a slash+netmask
      $searchfor = "ipblock";
    } else {
      # Anything else.
      $searchfor = "desc";
    }
    viewBy($searchfor, $webvar{input});
  }

} elsif ($webvar{stype} eq 'c') {
  # Complex search.

  # Several major cases, and a whole raft of individual cases.
  # -> Show all types means we do not need to limit records retrieved by type
  # -> Show all cities means we do not need to limit records retrieved by city
  # Individual cases are for the CIDR/IP, CustID, Description, Notes, and individual type
  # requests.

  my $sqlconcat;
  if ($webvar{which} eq 'all') {
    # Must match *all* specified criteria.	## use INTERSECT or EXCEPT
    $sqlconcat = "INTERSECT";
  } elsif ($webvar{which} eq 'any') {
    # Match on any specified criteria		## use UNION
    $sqlconcat = "UNION";
  } else {
    # sum-buddy tryn'a game the system.  Match "all"
    $sqlconcat = "INTERSECT";
  }

# We actually construct a monster SQL statement for all criteria.
# Iff something has been entered, it will be used as a filter.
# Iff something has NOT been entered, we still include it but in
# such a way that it does not actually filter anything out.

  # hack fix for undefined variables
  $webvar{custid} = '' if !$webvar{custid};
  $webvar{desc}   = '' if !$webvar{desc};
  $webvar{notes}  = '' if !$webvar{notes};
  $webvar{custexclude}  = '' if !$webvar{custexclude};
  $webvar{descexclude}  = '' if !$webvar{descexclude};
  $webvar{notesexclude} = '' if !$webvar{notesexclude};

  # First chunk of SQL.  Filter on custid, description, and notes as necessary.
  my $sql = qq(SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id\n);
  $sql .= " WHERE $webvar{custexclude} (s.custid ~ '$webvar{custid}')\n" if $webvar{custid};
  $sql .= " $sqlconcat (SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id WHERE $webvar{descexclude} s.description ~ '$webvar{desc}')\n" if $webvar{desc};
  $sql .= " $sqlconcat (SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id WHERE $webvar{notesexclude} s.notes ~ '$webvar{notes}')" if $webvar{notes};

  # If we're not supposed to search for all types, search for the selected types.
  $webvar{alltypes} = '' if !$webvar{alltypes};
  $webvar{typeexclude} = '' if !$webvar{typeexclude};
  if ($webvar{alltypes} ne 'on') {
    $sql .= " $sqlconcat (SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id WHERE $webvar{typeexclude} s.type IN (";
    foreach my $key (keys %webvar) {
      $sql .= "'$1'," if $key =~ /type\[(..)\]/;
    }
    chop $sql;
    $sql .= "))";
  }

  # If we're not supposed to search for all cities, search for the selected cities.
  # This could be vastly improved with proper foreign keys in the database.
  $webvar{allcities} = '' if !$webvar{allcities};
  $webvar{cityexclude} = '' if !$webvar{cityexclude};
  if ($webvar{allcities} ne 'on') {
    $sql .= " $sqlconcat (SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id WHERE $webvar{cityexclude} s.city IN (";
    $sth = $ip_dbh->prepare("SELECT city FROM cities WHERE id=?");
    foreach my $key (keys %webvar) {
      if ($key =~ /city\[(\d+)\]/) {
        $sth->execute($1);
        my $city;
        $sth->bind_columns(\$city);
        $sth->fetch;
        $city =~ s/'/''/;
        $sql .= "'$city',";
      }
    }
    chop $sql;
    $sql .= "))";
  }

  ## CIDR query options.
  $webvar{cidr} =~ s/\s+//;	# Hates the nasty spaceseseses we does.
  if ($webvar{cidr} eq '') { # We has a blank CIDR.  Ignore it.
  } elsif ($webvar{cidr} =~ /\//) {
    # 192.168.179/26 should show all /26 subnets in 192.168.179
    my ($net,$maskbits) = split /\//, $webvar{cidr};
    if ($webvar{cidr} =~ /^(\d{1,3}\.){3}\d{1,3}\/\d{2}$/) {
      # /0->/9 are silly to worry about right now.  I don't think
      # we'll be getting a class A anytime soon.  <g>
      $sql .= " $sqlconcat (SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id WHERE ".
	"$webvar{cidrexclude} s.cidr<<='$webvar{cidr}')";
    } else {
      # Partial match;  beginning of subnet and maskbits are provided
      # Show any blocks with the leading octet(s) and that masklength
      # Need some more magic for bare /nn searches:
      my $condition = ($net eq '' ?
	"masklen(s.cidr)=$maskbits" : "text(s.cidr) like '$net%' and masklen(s.cidr)=$maskbits");
      $sql .= " $sqlconcat (select $cols from searchme s JOIN allocations a ON s.master_id=a.id where $webvar{cidrexclude} ".
	"($condition))";
    }
  } elsif ($webvar{cidr} =~ /^(\d{1,3}\.){3}\d{1,3}$/) {
    # Specific IP address match.  Will show either a single netblock,
    # or a static pool plus an IP.
    $sql .= " $sqlconcat (select $cols from searchme s JOIN allocations a ON s.master_id=a.id where $webvar{cidrexclude} ".
	"s.cidr >>= '$webvar{cidr}')";
  } elsif ($webvar{cidr} =~ /^\d{1,3}(\.(\d{1,3}(\.(\d{1,3}\.?)?)?)?)?$/) {
    # Leading octets in CIDR
    $sql .= " $sqlconcat (select $cols from searchme s JOIN allocations a ON s.master_id=a.id where $webvar{cidrexclude} ".
	"text(s.cidr) like '$webvar{cidr}%')";
  } else {
    # do nothing.
    ##fixme  we'll ignore this to clear out the references to legacy code.
  } # done with CIDR query options.

  # Find the offset for multipage results
  my $offset = ($webvar{page}-1)*$RESULTS_PER_PAGE;

  # Find out how many rows the "core" query will return.
  my $count = countRows($sql);

# join against yourself!  only master blocks are really guaranteed to have a VRF set - especially in legacy data
#$sql .= " JOIN allocations mv ON 

  if ($count == 0) {
    $page->param(errmsg => "No matches found.  Try eliminating one of the criteria,".
	" or making one or more criteria more general.");
  } else {
    # Add the limit/offset clauses
    $sql .= " order by cidr";
    $sql .= " limit $RESULTS_PER_PAGE offset $offset" if $RESULTS_PER_PAGE != 0;
    # And tell the user.
    print "<div class=heading>Searching...............</div>\n";
    queryResults($sql, $webvar{page}, $count);
  }

} elsif ($webvar{stype} eq 'n') {
  # Node search.

  my $sql = "SELECT $cols FROM searchme".
	" WHERE cidr IN (SELECT block FROM noderef WHERE node_id=$webvar{node})";

  # Find the offset for multipage results
  my $offset = ($webvar{page}-1)*$RESULTS_PER_PAGE;

  # Find out how many rows the "core" query will return.
  my $count = countRows($sql);

  if ($count == 0) {
    $page->param(errmsg => "No customers currently listed as connected through this node.");
##fixme:  still get the results table header
  } else {
    # Add the limit/offset clauses
    $sql .= " order by cidr";
    $sql .= " limit $RESULTS_PER_PAGE offset $offset" if $RESULTS_PER_PAGE != 0;
    # And tell the user.
    print "<div class=heading>Searching...............</div>\n";
    queryResults($sql, $webvar{page}, $count);
  }

} else { # how script was called.  General case is to show the search criteria page.

# Generate table of types
  $sth = $ip_dbh->prepare("select type,dispname from alloctypes where listorder <500 ".
	"order by listorder");
  $sth->execute;
  my $i=0;
  my @typelist;
  while (my ($type,$dispname) = $sth->fetchrow_array) {
    my %row = (
	newrow => ($i % 4 == 0),
	type => $type,
	dispname => $dispname,
	endrow => ($i++ % 4 == 3)
	);
    push @typelist, \%row;
  }
  $page->param(typelist => \@typelist);

# Generate table of cities
  $sth = $ip_dbh->prepare("select id,city from cities order by city");
  $sth->execute;
  $i=0;
  my @citylist;
  while (my ($id, $city) = $sth->fetchrow_array) {
    my %row = (
	newrow => ($i % 4 == 0),
	id => $id,
	city => $city,
	endrow => ($i++ % 4 == 3)
	);	
    push @citylist, \%row;
  }
  $page->param(citylist => \@citylist);

}

print $page->output;

# Shut down and clean up.
finish($ip_dbh);

# We print the footer here, so we don't have to do it elsewhere.
my $footer = HTML::Template->new(filename => "footer.tmpl", path => @templatepath);
# include the admin tools link in the output?
$footer->param(adminlink => ($IPDBacl{$authuser} =~ /A/));

print $footer->output;

# We shouldn't need to directly execute any code below here;  it's all subroutines.
exit 0;


# viewBy()
# The quick search
# Takes a category descriptor and a query string
# Creates appropriate SQL to run the search and display the results
# with queryResults()
sub viewBy {
  my ($category,$query) = @_;

  # Local variables
  my $sql;

  # Calculate start point for LIMIT clause
  my $offset = ($webvar{page}-1)*$RESULTS_PER_PAGE;

# Possible cases:
# 1) Partial IP/subnet.  Treated as "octet-prefix".
# 2a) CIDR subnet.  Exact match.
# 2b) CIDR netmask.  YMMV but it should be octet-prefix-with-netmask
#	(ie, all matches with the octet prefix *AND* that netmask)
# 3) Customer ID.  "Match-any-segment"
# 4) Description.  "Match-any-segment"
# 5) Invalid data which might be interpretable as an IP or something, but
#    which probably shouldn't be for reasons of sanity.

  if ($category eq 'all') {

    $sql = "select $cols from searchme s JOIN allocations a ON s.master_id=a.id";
    my $count = countRows($sql);
    $sql .= " order by s.cidr limit $RESULTS_PER_PAGE offset $offset";
    queryResults($sql, $webvar{page}, $count);

  } elsif ($category eq 'cust') {

##fixme:  this and other quick-search areas;  fix up page heading title similar to first grouping above
    print qq(<div class="heading">Searching for Customer IDs containing '$query'</div><br>\n);

    # Query for a customer ID.  Note that we can't restrict to "numeric-only"
    # as we have non-numeric custIDs in the legacy data.  :/
    $sql = "select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.custid ilike '%$query%' or s.description like '%$query%'";
    my $count = countRows($sql);
    $sql .= " order by s.cidr limit $RESULTS_PER_PAGE offset $offset";
    queryResults($sql, $webvar{page}, $count);

  } elsif ($category eq 'desc') {

    print qq(<div class="heading">Searching for descriptions containing '$query'</div><br>\n);
    # Query based on description (includes "name" from old DB).
    $sql = "select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.description ilike '%$query%'".
	" or s.custid ilike '%$query%'";
    my $count = countRows($sql);
    $sql .= " order by s.cidr limit $RESULTS_PER_PAGE offset $offset";
    queryResults($sql, $webvar{page}, $count);

  } elsif ($category =~ /ipblock/) {

    # Query is for a partial IP, a CIDR block in some form, or a flat IP.
    print qq(<div class="heading">Searching for IP-based matches on '$query'</div><br>\n);

    $query =~ s/\s+//g;
    if ($query =~ /\//) {
      # 192.168.179/26 should show all /26 subnets in 192.168.179
      my ($net,$maskbits) = split /\//, $query;
      if ($query =~ /^(\d{1,3}\.){3}\d{1,3}\/\d{2}$/) {
	# /0->/9 are silly to worry about right now.  I don't think
	# we'll be getting a class A anytime soon.  <g>
        $sql = "select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.cidr='$query'";
	queryResults($sql, $webvar{page}, 1);
      } else {
	#print "Finding all blocks with netmask /$maskbits, leading octet(s) $net<br>\n";
	# Partial match;  beginning of subnet and maskbits are provided
	$sql = "select $cols from searchme s JOIN allocations a ON s.master_id=a.id".
		" where text(s.cidr) like '$net%' and text(s.cidr) like '%$maskbits'";
	my $count = countRows($sql);
	$sql .= " order by s.cidr limit $RESULTS_PER_PAGE offset $offset";
	queryResults($sql, $webvar{page}, $count);
      }
    } elsif ($query =~ /^(\d{1,3}\.){3}\d{1,3}$/) {
      # Specific IP address match
      #print "4-octet pattern found;  finding netblock containing IP $query<br>\n";
      my ($net,$ip) = ($query =~ /(\d{1,3}\.\d{1,3}\.\d{1,3}\.)(\d{1,3})/);
      my $sfor = new NetAddr::IP $query;
#      $sth = $ip_dbh->prepare("select $cols from searchme s JOIN allocations a ON s.master_id=a.id where text(s.cidr) like '$net%'");
#print "select $cols from searchme s JOIN allocations a ON s.master_id=a.id where text(s.cidr) like '$net%'";

#      $sth->execute;
#      while (my @data = $sth->fetchrow_array()) {
#        my $cidr = new NetAddr::IP $data[0];
#	if ($cidr->contains($sfor) || $cidr == $sfor) {
#print "cidr: $data[0]\n";
#print "<br>select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.cidr='$cidr' and s.type <> 'mm'";
	  queryResults(
#"select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.cidr='$cidr' and s.type <> 'mm'",
"select $cols from searchme s JOIN allocations a ON s.master_id=a.id where s.cidr >>= '$sfor' and s.type <> 'mm' order by masklen(s.cidr) desc",
 $webvar{page}, 1);
#print $page->output;
#	}
#      }
    } elsif ($query =~ /^(\d{1,3}\.){1,3}\d{1,3}\.?$/) {
      #print "Finding matches with leading octet(s) $query<br>\n";
      $sql = "SELECT $cols FROM searchme s JOIN allocations a ON s.master_id=a.id".
	" WHERE text(s.cidr) LIKE '$query%'";
      my $count = countRows($sql);
      $sql .= " order by s.cidr limit $RESULTS_PER_PAGE offset $offset";
      queryResults($sql, $webvar{page}, $count);
    } else {
      # This shouldn't happen, but if it does, whoever gets it deserves what they get...
      $page->param(errmsg => "Invalid query.");
    }
  } else {
    # This shouldn't happen, but if it does, whoever gets it deserves what they get...
    $page->param(errmsg => "Invalid searchfor.");
  }
} # viewBy



# queryResults()
# Display search queries based on the passed SQL.
# Takes SQL, page number (for multipage search results), and a total count.
sub queryResults {
  my ($sql, $pageNo, $rowCount) = @_;
  my $offset = 0;
  $offset = $1 if($sql =~ m/.*limit\s+(.*),.*/);

  my $sth = $ip_dbh->prepare($sql);
  $sth->execute();

  $page->param(searchtitle => "Showing all netblock and static-IP allocations");

  my $count = 0;
  my @sresults;
  while (my ($block, $custid, $type, $city, $desc, $id, $parent, $avail, $vrf) = $sth->fetchrow_array) {
    my %row = (
	rowclass => $count++ % 2,
        vrf => $vrf,
	issub => ($type =~ /^.r$/ ? 1 : 0),
	ispool => ($type =~ /^.[pd]$/ ? 1 : 0),
	basetype => ($type =~ /^.i/ ? 'i' : 'b'),
	freeip => ($avail eq 'y'),
	parent => $parent,
	block => $block,
	custid => $custid,
	disptype => $disp_alloctypes{$type},
	city => $city,
	desc => $desc,
	id => $id,
	);
    push @sresults, \%row;
  }
  $page->param(sresults => \@sresults);

  # Have to think on this call, it's primarily to clean up unfetched rows from a select.
  # In this context it's probably a good idea.
  $sth->finish();

  my $upper = $offset+$count;

  $page->param(resfound => $rowCount);
  $page->param(resstart => $offset+1);
  $page->param(resstop => $upper);

  # print the page thing..
  if ($RESULTS_PER_PAGE > 0 && $rowCount > $RESULTS_PER_PAGE) {
    $page->param(multipage => 1);
    my $pages = ceil($rowCount/$RESULTS_PER_PAGE);
    my @pagelist;
    for (my $i = 1; $i <= $pages; $i++) {
      my %row;
      $row{pgnum} = $i;
      if ($i == $pageNo) {
	$row{thispage} = 1;
      } else {
	$row{stype} = $webvar{stype};
	if ($webvar{stype} eq 'c') {
	  $row{extraopts} = "cidr=$webvar{cidr}&custid=$webvar{custid}&desc=$webvar{desc}&".
		"notes=$webvar{notes}&which=$webvar{which}&alltypes=$webvar{alltypes}&".
		"allcities=$webvar{allcities}&";
	  foreach my $key (keys %webvar) {
	    if ($key =~ /^(?:type|city)\[/ || $key =~ /exclude$/) {
	      $row{extraopts} .= "$key=$webvar{$key}&";
	    }
	  }
	} else {
	  $row{extraopts} = "input=$webvar{input}&";
	}
      }
      push @pagelist, \%row;
    }
    $page->param(pgnums => \@pagelist);
  }

} # queryResults



# Return count of rows to be returned in a "real" query
# with the passed SQL statement
sub countRows {
  # Note that the "as foo" is required
  my $sth = $ip_dbh->prepare("select count(*) from ($_[0]) as foo");
  $sth->execute();
  my @a = $sth->fetchrow_array();
  $sth->finish();
  return $a[0];
}
