#!/usr/bin/perl
# ipdb/cgi-bin/consistency-check.pl
# Does full check to see if the data in the db is consistent and complete.
###
# SVN revision info
# $Date$
# SVN revision $Rev$
# Last update by $Author$
###

use DBI;
use IPDB qw(:ALL);
use NetAddr::IP;

$dbh = connectDB;

# Schlep up the masters
$sth = $dbh->prepare("select * from masterblocks order by cidr");
$sth->execute;
for ($i=0; @data = $sth->fetchrow_array; $i++) {
  $masterblocks[$i] = new NetAddr::IP $data[0];
}

print "First check:  All blocks must be within one of the master blocks\n";

# First check - make sure ALL routes and allocated blocks are part
# of one of the master blocks.
print "Checking routed blocks: ";
$sth = $dbh->prepare("select cidr from routed");
# union select cidr from allocations union select cidr from freeblocks");
$sth->execute;
ROUTED: while (@data = $sth->fetchrow_array) {
  $cidr = new NetAddr::IP $data[0];
  foreach $master (@masterblocks) {
    if ($master->contains($cidr)) { next ROUTED; }
  }
  print "$cidr not mastered\n";
}
print " done.\n";

# Next test:  All allocations must be part of a master.
print "Checking allocations: ";
$sth = $dbh->prepare("select cidr from allocations");
$sth->execute;
ALLOCATED: while (@data = $sth->fetchrow_array) {
  $cidr = new NetAddr::IP $data[0];
  foreach $master (@masterblocks) {
    if ($master->contains($cidr)) { next ALLOCATED; }
  }
  print "$cidr not mastered\n";
}
print " done.\n";

# Next:  free blocks
print "Checking freeblocks: ";
$sth = $dbh->prepare("select cidr from freeblocks");
$sth->execute;
FREEBLOCK: while (@data = $sth->fetchrow_array) {
  $cidr = new NetAddr::IP $data[0];
  foreach $master (@masterblocks) {
    if ($master->contains($cidr)) { next FREEBLOCK; }
  }
  print "$cidr not mastered\n";
}
print " done.\n";

print "Done checking master containment.\n\nChecking block-alignment consistency:\n";

# Block alignment consistency:  All allocated+free blocks within a master
# must NOT overlap, and they must show no gaps.
# eg, if we have blocks:
#  master is 192.168.2.0/24
#  allocated 192.168.2.0/29, 192.168.2.8/29, 192.168.2.64/26
#  free 192.168.2.16/28, 192.168.2.32/27, 192.168.2.128/25
# then we're OK, but if any one of the allocated or free blocks is missing,
# something b0rked.

# (select cidr from allocations where cidr <<= '$master') union
#  (select cidr from freeblocks where cidr <<= '$master')
#  order by cidr

foreach $master (@masterblocks) {
  print "Master $master:\n";
  ($next,undef) = split /\//, $master;
  ($last,undef) = split /\//, ($master->broadcast);
  $sth = $dbh->prepare("(select network(cidr) as net, broadcast(cidr) as bcast ".
	" from allocations where cidr <<= '$master') union ".
	"(select network(cidr) as net, broadcast(cidr) as bcast ".
	"from freeblocks where cidr <<= '$master') order by net");
  $sth->execute;
  while (@data = $sth->fetchrow_array) {
    ($cur,undef) = split /\//, $data[0];
    if ($master !~ /$next/) {
      ($tmp,undef) = split /\//, $next;
      @tmp1 = split /\./, $tmp;
      $tmp1[3]++;
      if ($tmp1[3] == 256) { $tmp1[3] = 0; $tmp1[2]++; }
      $cmp = join '.', @tmp1;
    } else {
      $cmp = $next;
    }
    if ($cur ne $cmp) {
      print " Gap from $next to $cur\n";
    }
    ($next,undef) = split /\//, $data[1];
  }
  if ($next ne $last) {
    print " Gap from $next to end of master at $last\n";
  }
  print "done $master.\n";
}
